/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.RawTensor;
import org.tensorflow.SparseTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.internal.types.SparseHelpers;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.impl.dense.ByteDenseNdArray;
import org.tensorflow.ndarray.impl.sparse.ByteSparseNdArray;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TUint8;

public final class TUint8Mapper
extends TensorMapper<TUint8> {
    @Override
    protected TUint8 mapDense(RawTensor tensor) {
        ByteDataBuffer buffer = TensorBuffers.toBytes(TUint8Mapper.nativeHandle(tensor));
        return new DenseTUint8(tensor, buffer);
    }

    @Override
    protected SparseTensor<TUint8> mapSparse(TInt64 indices, TUint8 values, TInt64 denseShape, PointerScope tensorScope) {
        return new SparseTUint8(indices, values, denseShape, tensorScope);
    }

    private static final class SparseTUint8
    extends ByteSparseNdArray
    implements TUint8,
    SparseTensor<TUint8> {
        private final TInt64 denseShape;
        private final PointerScope tensorScope;

        public Class<TUint8> type() {
            return TUint8.class;
        }

        @Override
        public DataType dataType() {
            return this.values().dataType();
        }

        @Override
        public long numBytes() {
            return SparseHelpers.numBytes(this);
        }

        @Override
        public void close() {
            this.tensorScope.close();
        }

        @Override
        public boolean isSparse() {
            return true;
        }

        @Override
        public TInt64 indices() {
            return (TInt64)this.getIndices();
        }

        @Override
        public TUint8 values() {
            return (TUint8)this.getValues();
        }

        @Override
        public TInt64 denseShape() {
            return this.denseShape;
        }

        SparseTUint8(TInt64 indices, TUint8 values, TInt64 denseShape, PointerScope tensorScope) {
            super((LongNdArray)indices, values, (byte)0, SparseHelpers.toDimensionalSpace(denseShape));
            this.denseShape = denseShape;
            this.tensorScope = tensorScope.extend();
        }
    }

    private static final class DenseTUint8
    extends ByteDenseNdArray
    implements TUint8 {
        final RawTensor rawTensor;

        public Class<TUint8> type() {
            return TUint8.class;
        }

        @Override
        public DataType dataType() {
            return this.asRawTensor().dataType();
        }

        @Override
        public long numBytes() {
            return this.asRawTensor().numBytes();
        }

        @Override
        public void close() {
            this.asRawTensor().close();
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTUint8(RawTensor rawTensor, ByteDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

