/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaSpmdFullToShardShape", inputsClass=Inputs.class)
public final class SpmdFullToShardShape<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "XlaSpmdFullToShardShape";
    private Output<T> output;

    public SpmdFullToShardShape(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> SpmdFullToShardShape<T> create(Scope scope, Operand<T> input, String manualSharding, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "SpmdFullToShardShape");
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("manual_sharding", manualSharding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dim != null) {
                    opBuilder.setAttr("dim", opts.dim);
                }
                if (opts.unspecifiedDims == null) continue;
                long[] unspecifiedDimsArray = new long[opts.unspecifiedDims.size()];
                for (int i = 0; i < unspecifiedDimsArray.length; ++i) {
                    unspecifiedDimsArray[i] = opts.unspecifiedDims.get(i);
                }
                opBuilder.setAttr("unspecified_dims", unspecifiedDimsArray);
            }
        }
        return new SpmdFullToShardShape<T>(opBuilder.build());
    }

    public static Options dim(Long dim) {
        return new Options().dim(dim);
    }

    public static Options unspecifiedDims(List<Long> unspecifiedDims) {
        return new Options().unspecifiedDims(unspecifiedDims);
    }

    public static Options unspecifiedDims(Long ... unspecifiedDims) {
        return new Options().unspecifiedDims(unspecifiedDims);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SpmdFullToShardShape.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SpmdFullToShardShape<T>> {
        public final Operand<T> input;
        public final DataType T;
        public final String manualSharding;
        public final long dim;
        public final long[] unspecifiedDims;

        public Inputs(GraphOperation op) {
            super(new SpmdFullToShardShape(op), op, Arrays.asList("T", "manual_sharding", "dim", "unspecified_dims"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.manualSharding = op.attributes().getAttrString("manual_sharding");
            this.dim = op.attributes().getAttrInt("dim");
            this.unspecifiedDims = op.attributes().getAttrIntList("unspecified_dims");
        }
    }

    public static class Options {
        private Long dim;
        private List<Long> unspecifiedDims;

        private Options() {
        }

        public Options dim(Long dim) {
            this.dim = dim;
            return this;
        }

        public Options unspecifiedDims(List<Long> unspecifiedDims) {
            this.unspecifiedDims = unspecifiedDims;
            return this;
        }

        public Options unspecifiedDims(Long ... unspecifiedDims) {
            this.unspecifiedDims = Arrays.asList(unspecifiedDims);
            return this;
        }
    }
}

