/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TBfloat16;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaDequantize", inputsClass=Inputs.class)
public final class Dequantize
extends RawOp
implements Operand<TBfloat16> {
    public static final String OP_NAME = "XlaDequantize";
    private Output<TBfloat16> output;

    public Dequantize(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static Dequantize create(Scope scope, Operand<? extends TType> input, Float minRange, Float maxRange, String mode, Boolean transposeOutput) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Dequantize");
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("min_range", minRange.floatValue());
        opBuilder.setAttr("max_range", maxRange.floatValue());
        opBuilder.setAttr("mode", mode);
        opBuilder.setAttr("transpose_output", transposeOutput);
        return new Dequantize(opBuilder.build());
    }

    public Output<TBfloat16> output() {
        return this.output;
    }

    @Override
    public Output<TBfloat16> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Dequantize.class)
    public static class Inputs
    extends RawOpInputs<Dequantize> {
        public final Operand<? extends TType> input;
        public final float minRange;
        public final float maxRange;
        public final String mode;
        public final boolean transposeOutput;

        public Inputs(GraphOperation op) {
            super(new Dequantize(op), op, Arrays.asList("min_range", "max_range", "mode", "transpose_output"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.minRange = op.attributes().getAttrFloat("min_range");
            this.maxRange = op.attributes().getAttrFloat("max_range");
            this.mode = op.attributes().getAttrString("mode");
            this.transposeOutput = op.attributes().getAttrBool("transpose_output");
        }
    }
}

