/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.debugging;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DebugNanCount", inputsClass=Inputs.class)
public final class DebugNanCount
extends RawOp
implements Operand<TInt64> {
    public static final String OP_NAME = "DebugNanCount";
    private Output<TInt64> output;

    public DebugNanCount(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static DebugNanCount create(Scope scope, Operand<? extends TType> input, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.deviceName != null) {
                    opBuilder.setAttr("device_name", opts.deviceName);
                }
                if (opts.tensorName != null) {
                    opBuilder.setAttr("tensor_name", opts.tensorName);
                }
                if (opts.debugUrls != null) {
                    String[] debugUrlsArray = new String[opts.debugUrls.size()];
                    for (int i = 0; i < debugUrlsArray.length; ++i) {
                        debugUrlsArray[i] = opts.debugUrls.get(i);
                    }
                    opBuilder.setAttr("debug_urls", debugUrlsArray);
                }
                if (opts.gatedGrpc == null) continue;
                opBuilder.setAttr("gated_grpc", opts.gatedGrpc);
            }
        }
        return new DebugNanCount(opBuilder.build());
    }

    public static Options deviceName(String deviceName) {
        return new Options().deviceName(deviceName);
    }

    public static Options tensorName(String tensorName) {
        return new Options().tensorName(tensorName);
    }

    public static Options debugUrls(List<String> debugUrls) {
        return new Options().debugUrls(debugUrls);
    }

    public static Options debugUrls(String ... debugUrls) {
        return new Options().debugUrls(debugUrls);
    }

    public static Options gatedGrpc(Boolean gatedGrpc) {
        return new Options().gatedGrpc(gatedGrpc);
    }

    public Output<TInt64> output() {
        return this.output;
    }

    @Override
    public Output<TInt64> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=DebugNanCount.class)
    public static class Inputs
    extends RawOpInputs<DebugNanCount> {
        public final Operand<? extends TType> input;
        public final DataType T;
        public final String deviceName;
        public final String tensorName;
        public final String[] debugUrls;
        public final boolean gatedGrpc;

        public Inputs(GraphOperation op) {
            super(new DebugNanCount(op), op, Arrays.asList("T", "device_name", "tensor_name", "debug_urls", "gated_grpc"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.deviceName = op.attributes().getAttrString("device_name");
            this.tensorName = op.attributes().getAttrString("tensor_name");
            this.debugUrls = op.attributes().getAttrStringList("debug_urls");
            this.gatedGrpc = op.attributes().getAttrBool("gated_grpc");
        }
    }

    public static class Options {
        private String deviceName;
        private String tensorName;
        private List<String> debugUrls;
        private Boolean gatedGrpc;

        private Options() {
        }

        public Options deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public Options tensorName(String tensorName) {
            this.tensorName = tensorName;
            return this;
        }

        public Options debugUrls(List<String> debugUrls) {
            this.debugUrls = debugUrls;
            return this;
        }

        public Options debugUrls(String ... debugUrls) {
            this.debugUrls = Arrays.asList(debugUrls);
            return this;
        }

        public Options gatedGrpc(Boolean gatedGrpc) {
            this.gatedGrpc = gatedGrpc;
            return this;
        }
    }
}

