/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="FractionalAvgPoolGrad", inputsClass=Inputs.class)
public final class FractionalAvgPoolGrad<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "FractionalAvgPoolGrad";
    private Output<T> output;

    public FractionalAvgPoolGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> FractionalAvgPoolGrad<T> create(Scope scope, Operand<TInt64> origInputTensorShape, Operand<T> outBackprop, Operand<TInt64> rowPoolingSequence, Operand<TInt64> colPoolingSequence, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(origInputTensorShape.asOutput());
        opBuilder.addInput(outBackprop.asOutput());
        opBuilder.addInput(rowPoolingSequence.asOutput());
        opBuilder.addInput(colPoolingSequence.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.overlapping == null) continue;
                opBuilder.setAttr("overlapping", opts.overlapping);
            }
        }
        return new FractionalAvgPoolGrad<T>(opBuilder.build());
    }

    public static Options overlapping(Boolean overlapping) {
        return new Options().overlapping(overlapping);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=FractionalAvgPoolGrad.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<FractionalAvgPoolGrad<T>> {
        public final Operand<TInt64> origInputTensorShape;
        public final Operand<T> outBackprop;
        public final Operand<TInt64> rowPoolingSequence;
        public final Operand<TInt64> colPoolingSequence;
        public final boolean overlapping;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new FractionalAvgPoolGrad(op), op, Arrays.asList("overlapping", "T"));
            int inputIndex = 0;
            this.origInputTensorShape = op.input(inputIndex++);
            this.outBackprop = op.input(inputIndex++);
            this.rowPoolingSequence = op.input(inputIndex++);
            this.colPoolingSequence = op.input(inputIndex++);
            this.overlapping = op.attributes().getAttrBool("overlapping");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean overlapping;

        private Options() {
        }

        public Options overlapping(Boolean overlapping) {
            this.overlapping = overlapping;
            return this;
        }
    }
}

