/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.EagerOperationBuilder;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.internal.WeakPointerScope;
import org.tensorflow.internal.c_api.TFE_Context;
import org.tensorflow.internal.c_api.TFE_ContextOptions;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.op.OpScope;
import org.tensorflow.op.Scope;
import org.tensorflow.proto.framework.ConfigProto;

public final class EagerSession
implements ExecutionEnvironment,
AutoCloseable {
    private static volatile EagerSession defaultSession = null;
    private final WeakPointerScope nativeResources;
    private TFE_Context nativeHandle;
    private final Scope baseScope = new OpScope(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EagerSession initDefault(Options options) {
        Class<EagerSession> clazz = EagerSession.class;
        synchronized (EagerSession.class) {
            if (defaultSession != null) {
                throw new IllegalStateException("Default eager session is already initialized");
            }
            defaultSession = options.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EagerSession getDefault() {
        if (defaultSession != null) return defaultSession;
        Class<EagerSession> clazz = EagerSession.class;
        synchronized (EagerSession.class) {
            if (defaultSession != null) return defaultSession;
            defaultSession = EagerSession.options().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultSession;
        }
    }

    public static EagerSession create() {
        return EagerSession.options().build();
    }

    public static Options options() {
        return new Options();
    }

    @Override
    public void close() {
        if (this == defaultSession) {
            throw new IllegalStateException("Default eager session cannot be closed");
        }
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeDefaultForTest() {
        Class<EagerSession> clazz = EagerSession.class;
        synchronized (EagerSession.class) {
            if (defaultSession != null) {
                defaultSession.doClose();
                defaultSession = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public OperationBuilder opBuilder(String type, String name, Scope scope) {
        this.checkSession();
        if (!this.isOpEnabled(type)) {
            throw new IllegalArgumentException("Op " + type + " is not valid in eager mode.");
        }
        return new EagerOperationBuilder(this, type, name, scope);
    }

    @Override
    public void attachFunction(ConcreteFunction function) {
        this.checkSession();
        try (PointerScope scope = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            tensorflow.TFE_ContextAddFunction(this.nativeHandle, function.nativeHandle(), status);
            status.throwExceptionIfNotOK();
            function.getDependencies().forEach(fn -> {
                TF_Status status2 = TF_Status.newStatus();
                tensorflow.TFE_ContextAddFunction(this.nativeHandle, fn, status2);
                status2.throwExceptionIfNotOK();
            });
        }
    }

    @Override
    public ExecutionEnvironment.Types environmentType() {
        return ExecutionEnvironment.Types.EAGER;
    }

    @Override
    public boolean isOpEnabled(String opType) {
        switch (opType) {
            case "VariableV2": 
            case "Placeholder": 
            case "Assign": {
                return false;
            }
        }
        return true;
    }

    @Override
    public void checkInput(Operation input) {
        if (!input.env().isEager()) {
            throw new IllegalArgumentException("Can't use graph operation " + input + " in eager mode.");
        }
    }

    @Override
    public Scope baseScope() {
        return this.baseScope;
    }

    @Override
    public boolean isInitializer(Operation op) {
        return false;
    }

    TFE_Context nativeHandle() {
        this.checkSession();
        return this.nativeHandle;
    }

    void attach(Pointer ... resources) {
        this.checkSession();
        for (Pointer r : resources) {
            this.nativeResources.attach(r);
        }
    }

    void detach(Pointer ... resources) {
        this.checkSession();
        for (Pointer r : resources) {
            this.nativeResources.detach(r);
        }
    }

    private EagerSession(Options options) {
        this.nativeResources = new WeakPointerScope();
        this.nativeHandle = EagerSession.allocate(options.async, options.devicePlacementPolicy.code, options.config);
    }

    private void checkSession() {
        if (this.nativeHandle == null || this.nativeHandle.isNull()) {
            throw new IllegalStateException("Eager session has been closed");
        }
    }

    private synchronized void doClose() {
        if (this.nativeHandle != null && !this.nativeHandle.isNull()) {
            this.nativeResources.close();
            EagerSession.delete(this.nativeHandle);
            this.nativeHandle = null;
        }
    }

    private static TFE_Context allocate(boolean async, int devicePlacementPolicy, ConfigProto config) {
        try (PointerScope scope = new PointerScope();){
            TFE_ContextOptions opts = TFE_ContextOptions.newContextOptions();
            TF_Status status = TF_Status.newStatus();
            if (config != null) {
                BytePointer configBytes = new BytePointer(config.toByteArray());
                tensorflow.TFE_ContextOptionsSetConfig(opts, (Pointer)configBytes, configBytes.capacity(), status);
                status.throwExceptionIfNotOK();
            }
            tensorflow.TFE_ContextOptionsSetAsync(opts, (byte)(async ? 1 : 0));
            tensorflow.TFE_ContextOptionsSetDevicePlacementPolicy(opts, devicePlacementPolicy);
            TFE_Context context = tensorflow.TFE_NewContext(opts, status);
            status.throwExceptionIfNotOK();
            TFE_Context tFE_Context = (TFE_Context)context.retainReference();
            return tFE_Context;
        }
    }

    private static void delete(TFE_Context handle) {
        if (handle == null || handle.isNull()) {
            return;
        }
        tensorflow.TFE_DeleteContext(handle);
    }

    static {
        try {
            Class.forName("org.tensorflow.TensorFlow");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Options {
        private boolean async = false;
        private DevicePlacementPolicy devicePlacementPolicy = DevicePlacementPolicy.SILENT;
        private ConfigProto config = null;

        public Options async(boolean value) {
            this.async = value;
            return this;
        }

        public Options devicePlacementPolicy(DevicePlacementPolicy value) {
            this.devicePlacementPolicy = value;
            return this;
        }

        public Options config(ConfigProto config) {
            this.config = config;
            return this;
        }

        public EagerSession build() {
            return new EagerSession(this);
        }

        private Options() {
        }
    }

    public static enum DevicePlacementPolicy {
        EXPLICIT(0),
        WARN(1),
        SILENT(2),
        SILENT_FOR_INT32(3);

        private final int code;

        private DevicePlacementPolicy(int code) {
            this.code = code;
        }
    }
}

