/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;

@OpMetadata(opType="MergeV2Checkpoints", inputsClass=Inputs.class)
public final class MergeV2Checkpoints
extends RawOp {
    public static final String OP_NAME = "MergeV2Checkpoints";

    public MergeV2Checkpoints(Operation operation) {
        super(operation, OP_NAME);
    }

    public static MergeV2Checkpoints create(Scope scope, Operand<TString> checkpointPrefixes, Operand<TString> destinationPrefix, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(checkpointPrefixes.asOutput());
        opBuilder.addInput(destinationPrefix.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.deleteOldDirs != null) {
                    opBuilder.setAttr("delete_old_dirs", opts.deleteOldDirs);
                }
                if (opts.allowMissingFiles == null) continue;
                opBuilder.setAttr("allow_missing_files", opts.allowMissingFiles);
            }
        }
        return new MergeV2Checkpoints(opBuilder.build());
    }

    public static Options deleteOldDirs(Boolean deleteOldDirs) {
        return new Options().deleteOldDirs(deleteOldDirs);
    }

    public static Options allowMissingFiles(Boolean allowMissingFiles) {
        return new Options().allowMissingFiles(allowMissingFiles);
    }

    @OpInputsMetadata(outputsClass=MergeV2Checkpoints.class)
    public static class Inputs
    extends RawOpInputs<MergeV2Checkpoints> {
        public final Operand<TString> checkpointPrefixes;
        public final Operand<TString> destinationPrefix;
        public final boolean deleteOldDirs;
        public final boolean allowMissingFiles;

        public Inputs(GraphOperation op) {
            super(new MergeV2Checkpoints(op), op, Arrays.asList("delete_old_dirs", "allow_missing_files"));
            int inputIndex = 0;
            this.checkpointPrefixes = op.input(inputIndex++);
            this.destinationPrefix = op.input(inputIndex++);
            this.deleteOldDirs = op.attributes().getAttrBool("delete_old_dirs");
            this.allowMissingFiles = op.attributes().getAttrBool("allow_missing_files");
        }
    }

    public static class Options {
        private Boolean deleteOldDirs;
        private Boolean allowMissingFiles;

        private Options() {
        }

        public Options deleteOldDirs(Boolean deleteOldDirs) {
            this.deleteOldDirs = deleteOldDirs;
            return this;
        }

        public Options allowMissingFiles(Boolean allowMissingFiles) {
            this.allowMissingFiles = allowMissingFiles;
            return this;
        }
    }
}

