/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaCallModule", inputsClass=Inputs.class)
public final class XlaCallModule
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "XlaCallModule";
    private List<Output<?>> output;

    public XlaCallModule(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static XlaCallModule create(Scope scope, Iterable<Operand<?>> args, String module, List<Shape> Sout, List<Class<? extends TType>> Tout, List<String> dimArgsSpec) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(args));
        opBuilder.setAttr("module", module);
        Shape[] SoutArray = new Shape[Sout.size()];
        for (int i = 0; i < SoutArray.length; ++i) {
            SoutArray[i] = Sout.get(i);
        }
        opBuilder.setAttr("Sout", SoutArray);
        opBuilder.setAttr("Tout", Operands.toDataTypes(Tout));
        String[] dimArgsSpecArray = new String[dimArgsSpec.size()];
        for (int i = 0; i < dimArgsSpecArray.length; ++i) {
            dimArgsSpecArray[i] = dimArgsSpec.get(i);
        }
        opBuilder.setAttr("dim_args_spec", dimArgsSpecArray);
        return new XlaCallModule(opBuilder.build());
    }

    public List<Output<?>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=XlaCallModule.class)
    public static class Inputs
    extends RawOpInputs<XlaCallModule> {
        public final Iterable<Operand<?>> args;
        public final String module;
        public final Shape[] Sout;
        public final DataType[] Tout;
        public final DataType[] Tin;
        public final String[] dimArgsSpec;

        public Inputs(GraphOperation op) {
            super(new XlaCallModule(op), op, Arrays.asList("module", "Sout", "Tout", "Tin", "dim_args_spec"));
            int inputIndex = 0;
            int argsLength = op.inputListLength("args");
            this.args = Arrays.asList((Operand[])op.inputList(inputIndex, argsLength));
            inputIndex += argsLength;
            this.module = op.attributes().getAttrString("module");
            this.Sout = op.attributes().getAttrShapeList("Sout");
            this.Tout = op.attributes().getAttrTypeList("Tout");
            this.Tin = op.attributes().getAttrTypeList("Tin");
            this.dimArgsSpec = op.attributes().getAttrStringList("dim_args_spec");
        }
    }
}

