/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaRngBitGenerator", inputsClass=Inputs.class)
public final class RngBitGenerator<U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "XlaRngBitGenerator";
    private Output<? extends TType> outputKey;
    private Output<U> output;

    public RngBitGenerator(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputKey = operation.output(outputIdx++);
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TNumber> RngBitGenerator<U> create(Scope scope, Operand<TInt32> algorithm, Operand<? extends TType> initialState, Operand<? extends TNumber> shape, Class<U> dtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "RngBitGenerator");
        opBuilder.addInput(algorithm.asOutput());
        opBuilder.addInput(initialState.asOutput());
        opBuilder.addInput(shape.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        return new RngBitGenerator<U>(opBuilder.build());
    }

    public Output<? extends TType> outputKey() {
        return this.outputKey;
    }

    public Output<U> output() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RngBitGenerator.class)
    public static class Inputs
    extends RawOpInputs<RngBitGenerator<?>> {
        public final Operand<TInt32> algorithm;
        public final Operand<? extends TType> initialState;
        public final Operand<? extends TNumber> shape;
        public final DataType dtype;
        public final DataType Tshape;

        public Inputs(GraphOperation op) {
            super(new RngBitGenerator(op), op, Arrays.asList("dtype", "Tshape"));
            int inputIndex = 0;
            this.algorithm = op.input(inputIndex++);
            this.initialState = op.input(inputIndex++);
            this.shape = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
            this.Tshape = op.attributes().getAttrType("Tshape");
        }
    }
}

