/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="StringNGrams", inputsClass=Inputs.class)
public final class StringNGrams<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "StringNGrams";
    private Output<TString> ngrams;
    private Output<T> ngramsSplits;

    public StringNGrams(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.ngrams = operation.output(outputIdx++);
        this.ngramsSplits = operation.output(outputIdx++);
    }

    public static <T extends TNumber> StringNGrams<T> create(Scope scope, Operand<TString> data, Operand<T> dataSplits, String separator, List<Long> ngramWidths, String leftPad, String rightPad, Long padWidth, Boolean preserveShortSequences) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(data.asOutput());
        opBuilder.addInput(dataSplits.asOutput());
        opBuilder.setAttr("separator", separator);
        long[] ngramWidthsArray = new long[ngramWidths.size()];
        for (int i = 0; i < ngramWidthsArray.length; ++i) {
            ngramWidthsArray[i] = ngramWidths.get(i);
        }
        opBuilder.setAttr("ngram_widths", ngramWidthsArray);
        opBuilder.setAttr("left_pad", leftPad);
        opBuilder.setAttr("right_pad", rightPad);
        opBuilder.setAttr("pad_width", padWidth);
        opBuilder.setAttr("preserve_short_sequences", preserveShortSequences);
        return new StringNGrams<T>(opBuilder.build());
    }

    public Output<TString> ngrams() {
        return this.ngrams;
    }

    public Output<T> ngramsSplits() {
        return this.ngramsSplits;
    }

    @OpInputsMetadata(outputsClass=StringNGrams.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<StringNGrams<T>> {
        public final Operand<TString> data;
        public final Operand<T> dataSplits;
        public final String separator;
        public final long[] ngramWidths;
        public final String leftPad;
        public final String rightPad;
        public final long padWidth;
        public final boolean preserveShortSequences;
        public final DataType Tsplits;

        public Inputs(GraphOperation op) {
            super(new StringNGrams(op), op, Arrays.asList("separator", "ngram_widths", "left_pad", "right_pad", "pad_width", "preserve_short_sequences", "Tsplits"));
            int inputIndex = 0;
            this.data = op.input(inputIndex++);
            this.dataSplits = op.input(inputIndex++);
            this.separator = op.attributes().getAttrString("separator");
            this.ngramWidths = op.attributes().getAttrIntList("ngram_widths");
            this.leftPad = op.attributes().getAttrString("left_pad");
            this.rightPad = op.attributes().getAttrString("right_pad");
            this.padWidth = op.attributes().getAttrInt("pad_width");
            this.preserveShortSequences = op.attributes().getAttrBool("preserve_short_sequences");
            this.Tsplits = op.attributes().getAttrType("Tsplits");
        }
    }
}

