/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseReduceSum", inputsClass=Inputs.class)
public final class SparseReduceSum<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "SparseReduceSum";
    private Output<T> output;

    public SparseReduceSum(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseReduceSum<T> create(Scope scope, Operand<TInt64> inputIndices, Operand<T> inputValues, Operand<TInt64> inputShape, Operand<TInt32> reductionAxes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputIndices.asOutput());
        opBuilder.addInput(inputValues.asOutput());
        opBuilder.addInput(inputShape.asOutput());
        opBuilder.addInput(reductionAxes.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.keepDims == null) continue;
                opBuilder.setAttr("keep_dims", opts.keepDims);
            }
        }
        return new SparseReduceSum<T>(opBuilder.build());
    }

    public static Options keepDims(Boolean keepDims) {
        return new Options().keepDims(keepDims);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SparseReduceSum.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SparseReduceSum<T>> {
        public final Operand<TInt64> inputIndices;
        public final Operand<T> inputValues;
        public final Operand<TInt64> inputShape;
        public final Operand<TInt32> reductionAxes;
        public final boolean keepDims;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new SparseReduceSum(op), op, Arrays.asList("keep_dims", "T"));
            int inputIndex = 0;
            this.inputIndices = op.input(inputIndex++);
            this.inputValues = op.input(inputIndex++);
            this.inputShape = op.input(inputIndex++);
            this.reductionAxes = op.input(inputIndex++);
            this.keepDims = op.attributes().getAttrBool("keep_dims");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean keepDims;

        private Options() {
        }

        public Options keepDims(Boolean keepDims) {
            this.keepDims = keepDims;
            return this;
        }
    }
}

