/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.risc;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RiscPool", inputsClass=Inputs.class)
public final class RiscPool<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "RiscPool";
    private Output<T> output;

    public RiscPool(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TNumber> RiscPool<T> create(Scope scope, Operand<T> value, List<Long> ksize, List<Long> strides, String poolingType, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(value.asOutput());
        long[] ksizeArray = new long[ksize.size()];
        for (int i = 0; i < ksizeArray.length; ++i) {
            ksizeArray[i] = ksize.get(i);
        }
        opBuilder.setAttr("ksize", ksizeArray);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("pooling_type", poolingType);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dataFormat == null) continue;
                opBuilder.setAttr("data_format", opts.dataFormat);
            }
        }
        return new RiscPool<T>(opBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RiscPool.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<RiscPool<T>> {
        public final Operand<T> value;
        public final long[] ksize;
        public final long[] strides;
        public final String poolingType;
        public final String dataFormat;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new RiscPool(op), op, Arrays.asList("ksize", "strides", "pooling_type", "data_format", "T"));
            int inputIndex = 0;
            this.value = op.input(inputIndex++);
            this.ksize = op.attributes().getAttrIntList("ksize");
            this.strides = op.attributes().getAttrIntList("strides");
            this.poolingType = op.attributes().getAttrString("pooling_type");
            this.dataFormat = op.attributes().getAttrString("data_format");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private String dataFormat;

        private Options() {
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }
    }
}

