/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.random;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="StatefulUniform", inputsClass=Inputs.class)
public final class StatefulUniform<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "StatefulUniform";
    private Output<U> output;

    public StatefulUniform(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TType> StatefulUniform<U> create(Scope scope, Operand<? extends TType> resource, Operand<TInt64> algorithm, Operand<? extends TType> shape, Class<U> dtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(resource.asOutput());
        opBuilder.addInput(algorithm.asOutput());
        opBuilder.addInput(shape.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        return new StatefulUniform<U>(opBuilder.build());
    }

    public static StatefulUniform<TFloat32> create(Scope scope, Operand<? extends TType> resource, Operand<TInt64> algorithm, Operand<? extends TType> shape) {
        return StatefulUniform.create(scope, resource, algorithm, shape, TFloat32.class);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=StatefulUniform.class)
    public static class Inputs
    extends RawOpInputs<StatefulUniform<?>> {
        public final Operand<? extends TType> resource;
        public final Operand<TInt64> algorithm;
        public final Operand<? extends TType> shape;
        public final DataType dtype;
        public final DataType shapeDtype;

        public Inputs(GraphOperation op) {
            super(new StatefulUniform(op), op, Arrays.asList("dtype", "shape_dtype"));
            int inputIndex = 0;
            this.resource = op.input(inputIndex++);
            this.algorithm = op.input(inputIndex++);
            this.shape = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
            this.shapeDtype = op.attributes().getAttrType("shape_dtype");
        }
    }
}

