/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RaggedTensorToTensor", inputsClass=Inputs.class)
public final class RaggedTensorToTensor<U extends TType>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "RaggedTensorToTensor";
    private Output<U> result;

    public RaggedTensorToTensor(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.result = operation.output(outputIdx++);
    }

    public static <U extends TType> RaggedTensorToTensor<U> create(Scope scope, Operand<? extends TNumber> shape, Operand<U> values, Operand<U> defaultValue, Iterable<Operand<? extends TNumber>> rowPartitionTensors, List<String> rowPartitionTypes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(shape.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(defaultValue.asOutput());
        opBuilder.addInputList(Operands.asOutputs(rowPartitionTensors));
        String[] rowPartitionTypesArray = new String[rowPartitionTypes.size()];
        for (int i = 0; i < rowPartitionTypesArray.length; ++i) {
            rowPartitionTypesArray[i] = rowPartitionTypes.get(i);
        }
        opBuilder.setAttr("row_partition_types", rowPartitionTypesArray);
        return new RaggedTensorToTensor<U>(opBuilder.build());
    }

    public Output<U> result() {
        return this.result;
    }

    @Override
    public Output<U> asOutput() {
        return this.result;
    }

    @OpInputsMetadata(outputsClass=RaggedTensorToTensor.class)
    public static class Inputs<U extends TType>
    extends RawOpInputs<RaggedTensorToTensor<U>> {
        public final Operand<? extends TNumber> shape;
        public final Operand<U> values;
        public final Operand<U> defaultValue;
        public final Iterable<Operand<? extends TNumber>> rowPartitionTensors;
        public final DataType T;
        public final DataType Tindex;
        public final DataType Tshape;
        public final String[] rowPartitionTypes;

        public Inputs(GraphOperation op) {
            super(new RaggedTensorToTensor(op), op, Arrays.asList("T", "Tindex", "Tshape", "row_partition_types"));
            int inputIndex = 0;
            this.shape = op.input(inputIndex++);
            this.values = op.input(inputIndex++);
            this.defaultValue = op.input(inputIndex++);
            int rowPartitionTensorsLength = op.inputListLength("row_partition_tensors");
            this.rowPartitionTensors = Arrays.asList((Operand[])op.inputList(inputIndex, rowPartitionTensorsLength));
            inputIndex += rowPartitionTensorsLength;
            this.T = op.attributes().getAttrType("T");
            this.Tindex = op.attributes().getAttrType("Tindex");
            this.Tshape = op.attributes().getAttrType("Tshape");
            this.rowPartitionTypes = op.attributes().getAttrStringList("row_partition_types");
        }
    }
}

