/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;

@OpMetadata(opType="ComputeAccidentalHits", inputsClass=Inputs.class)
public final class ComputeAccidentalHits
extends RawOp {
    public static final String OP_NAME = "ComputeAccidentalHits";
    private Output<TInt32> indices;
    private Output<TInt64> ids;
    private Output<TFloat32> weights;

    public ComputeAccidentalHits(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.indices = operation.output(outputIdx++);
        this.ids = operation.output(outputIdx++);
        this.weights = operation.output(outputIdx++);
    }

    public static ComputeAccidentalHits create(Scope scope, Operand<TInt64> trueClasses, Operand<TInt64> sampledCandidates, Long numTrue, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(trueClasses.asOutput());
        opBuilder.addInput(sampledCandidates.asOutput());
        opBuilder.setAttr("num_true", numTrue);
        if (options != null) {
            for (Options opts : options) {
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new ComputeAccidentalHits(opBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<TInt32> indices() {
        return this.indices;
    }

    public Output<TInt64> ids() {
        return this.ids;
    }

    public Output<TFloat32> weights() {
        return this.weights;
    }

    @OpInputsMetadata(outputsClass=ComputeAccidentalHits.class)
    public static class Inputs
    extends RawOpInputs<ComputeAccidentalHits> {
        public final Operand<TInt64> trueClasses;
        public final Operand<TInt64> sampledCandidates;
        public final long numTrue;
        public final long seed;
        public final long seed2;

        public Inputs(GraphOperation op) {
            super(new ComputeAccidentalHits(op), op, Arrays.asList("num_true", "seed", "seed2"));
            int inputIndex = 0;
            this.trueClasses = op.input(inputIndex++);
            this.sampledCandidates = op.input(inputIndex++);
            this.numTrue = op.attributes().getAttrInt("num_true");
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
        }
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        private Options() {
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }
    }
}

