/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CSRSparseMatrixComponents", inputsClass=Inputs.class)
public final class CSRSparseMatrixComponents<T extends TType>
extends RawOp {
    public static final String OP_NAME = "CSRSparseMatrixComponents";
    private Output<TInt32> rowPtrs;
    private Output<TInt32> colInds;
    private Output<T> values;

    public CSRSparseMatrixComponents(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.rowPtrs = operation.output(outputIdx++);
        this.colInds = operation.output(outputIdx++);
        this.values = operation.output(outputIdx++);
    }

    public static <T extends TType> CSRSparseMatrixComponents<T> create(Scope scope, Operand<? extends TType> csrSparseMatrix, Operand<TInt32> index, Class<T> type) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(csrSparseMatrix.asOutput());
        opBuilder.addInput(index.asOutput());
        opBuilder.setAttr("type", Operands.toDataType(type));
        return new CSRSparseMatrixComponents<T>(opBuilder.build());
    }

    public Output<TInt32> rowPtrs() {
        return this.rowPtrs;
    }

    public Output<TInt32> colInds() {
        return this.colInds;
    }

    public Output<T> values() {
        return this.values;
    }

    @OpInputsMetadata(outputsClass=CSRSparseMatrixComponents.class)
    public static class Inputs
    extends RawOpInputs<CSRSparseMatrixComponents<?>> {
        public final Operand<? extends TType> csrSparseMatrix;
        public final Operand<TInt32> index;
        public final DataType type;

        public Inputs(GraphOperation op) {
            super(new CSRSparseMatrixComponents(op), op, Arrays.asList("type"));
            int inputIndex = 0;
            this.csrSparseMatrix = op.input(inputIndex++);
            this.index = op.input(inputIndex++);
            this.type = op.attributes().getAttrType("type");
        }
    }
}

