/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="MatrixSolve", inputsClass=Inputs.class)
public final class Solve<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "MatrixSolve";
    private Output<T> output;

    public Solve(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> Solve<T> create(Scope scope, Operand<T> matrix, Operand<T> rhs, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "Solve");
        opBuilder.addInput(matrix.asOutput());
        opBuilder.addInput(rhs.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.adjoint == null) continue;
                opBuilder.setAttr("adjoint", opts.adjoint);
            }
        }
        return new Solve<T>(opBuilder.build());
    }

    public static Options adjoint(Boolean adjoint) {
        return new Options().adjoint(adjoint);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Solve.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Solve<T>> {
        public final Operand<T> matrix;
        public final Operand<T> rhs;
        public final boolean adjoint;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new Solve(op), op, Arrays.asList("adjoint", "T"));
            int inputIndex = 0;
            this.matrix = op.input(inputIndex++);
            this.rhs = op.input(inputIndex++);
            this.adjoint = op.attributes().getAttrBool("adjoint");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean adjoint;

        private Options() {
        }

        public Options adjoint(Boolean adjoint) {
            this.adjoint = adjoint;
            return this;
        }
    }
}

