/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="ResizeNearestNeighbor", inputsClass=Inputs.class)
public final class ResizeNearestNeighbor<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ResizeNearestNeighbor";
    private Output<T> resizedImages;

    public ResizeNearestNeighbor(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.resizedImages = operation.output(outputIdx++);
    }

    public static <T extends TNumber> ResizeNearestNeighbor<T> create(Scope scope, Operand<T> images, Operand<TInt32> sizeOutput, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(sizeOutput.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.alignCorners != null) {
                    opBuilder.setAttr("align_corners", opts.alignCorners);
                }
                if (opts.halfPixelCenters == null) continue;
                opBuilder.setAttr("half_pixel_centers", opts.halfPixelCenters);
            }
        }
        return new ResizeNearestNeighbor<T>(opBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public static Options halfPixelCenters(Boolean halfPixelCenters) {
        return new Options().halfPixelCenters(halfPixelCenters);
    }

    public Output<T> resizedImages() {
        return this.resizedImages;
    }

    @Override
    public Output<T> asOutput() {
        return this.resizedImages;
    }

    @OpInputsMetadata(outputsClass=ResizeNearestNeighbor.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<ResizeNearestNeighbor<T>> {
        public final Operand<T> images;
        public final Operand<TInt32> sizeOutput;
        public final DataType T;
        public final boolean alignCorners;
        public final boolean halfPixelCenters;

        public Inputs(GraphOperation op) {
            super(new ResizeNearestNeighbor(op), op, Arrays.asList("T", "align_corners", "half_pixel_centers"));
            int inputIndex = 0;
            this.images = op.input(inputIndex++);
            this.sizeOutput = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.alignCorners = op.attributes().getAttrBool("align_corners");
            this.halfPixelCenters = op.attributes().getAttrBool("half_pixel_centers");
        }
    }

    public static class Options {
        private Boolean alignCorners;
        private Boolean halfPixelCenters;

        private Options() {
        }

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }

        public Options halfPixelCenters(Boolean halfPixelCenters) {
            this.halfPixelCenters = halfPixelCenters;
            return this;
        }
    }
}

