/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ExperimentalMapDataset", inputsClass=Inputs.class)
public final class MapDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ExperimentalMapDataset";
    private Output<? extends TType> handle;

    public MapDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static MapDataset create(Scope scope, Operand<? extends TType> inputDataset, Iterable<Operand<?>> otherArguments, ConcreteFunction f, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "MapDataset");
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInputList(Operands.asOutputs(otherArguments));
        opBuilder.setAttr("f", f);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.useInterOpParallelism != null) {
                    opBuilder.setAttr("use_inter_op_parallelism", opts.useInterOpParallelism);
                }
                if (opts.preserveCardinality == null) continue;
                opBuilder.setAttr("preserve_cardinality", opts.preserveCardinality);
            }
        }
        return new MapDataset(opBuilder.build());
    }

    public static Options useInterOpParallelism(Boolean useInterOpParallelism) {
        return new Options().useInterOpParallelism(useInterOpParallelism);
    }

    public static Options preserveCardinality(Boolean preserveCardinality) {
        return new Options().preserveCardinality(preserveCardinality);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=MapDataset.class)
    public static class Inputs
    extends RawOpInputs<MapDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Iterable<Operand<?>> otherArguments;
        public final DataType[] Targuments;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final boolean useInterOpParallelism;
        public final boolean preserveCardinality;

        public Inputs(GraphOperation op) {
            super(new MapDataset(op), op, Arrays.asList("Targuments", "output_types", "output_shapes", "use_inter_op_parallelism", "preserve_cardinality"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            int otherArgumentsLength = op.inputListLength("other_arguments");
            this.otherArguments = Arrays.asList((Operand[])op.inputList(inputIndex, otherArgumentsLength));
            inputIndex += otherArgumentsLength;
            this.Targuments = op.attributes().getAttrTypeList("Targuments");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.useInterOpParallelism = op.attributes().getAttrBool("use_inter_op_parallelism");
            this.preserveCardinality = op.attributes().getAttrBool("preserve_cardinality");
        }
    }

    public static class Options {
        private Boolean useInterOpParallelism;
        private Boolean preserveCardinality;

        private Options() {
        }

        public Options useInterOpParallelism(Boolean useInterOpParallelism) {
            this.useInterOpParallelism = useInterOpParallelism;
            return this;
        }

        public Options preserveCardinality(Boolean preserveCardinality) {
            this.preserveCardinality = preserveCardinality;
            return this;
        }
    }
}

