/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ShuffleAndRepeatDatasetV2", inputsClass=Inputs.class)
public final class ShuffleAndRepeatDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ShuffleAndRepeatDatasetV2";
    private Output<? extends TType> handle;

    public ShuffleAndRepeatDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static ShuffleAndRepeatDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TInt64> bufferSize, Operand<TInt64> seed, Operand<TInt64> seed2, Operand<TInt64> count, Operand<? extends TType> seedGenerator, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "ShuffleAndRepeatDataset");
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(bufferSize.asOutput());
        opBuilder.addInput(seed.asOutput());
        opBuilder.addInput(seed2.asOutput());
        opBuilder.addInput(count.asOutput());
        opBuilder.addInput(seedGenerator.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.reshuffleEachIteration != null) {
                    opBuilder.setAttr("reshuffle_each_iteration", opts.reshuffleEachIteration);
                }
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new ShuffleAndRepeatDataset(opBuilder.build());
    }

    public static Options reshuffleEachIteration(Boolean reshuffleEachIteration) {
        return new Options().reshuffleEachIteration(reshuffleEachIteration);
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=ShuffleAndRepeatDataset.class)
    public static class Inputs
    extends RawOpInputs<ShuffleAndRepeatDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TInt64> bufferSize;
        public final Operand<TInt64> seed;
        public final Operand<TInt64> seed2;
        public final Operand<TInt64> count;
        public final Operand<? extends TType> seedGenerator;
        public final boolean reshuffleEachIteration;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new ShuffleAndRepeatDataset(op), op, Arrays.asList("reshuffle_each_iteration", "output_types", "output_shapes", "metadata"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.bufferSize = op.input(inputIndex++);
            this.seed = op.input(inputIndex++);
            this.seed2 = op.input(inputIndex++);
            this.count = op.input(inputIndex++);
            this.seedGenerator = op.input(inputIndex++);
            this.reshuffleEachIteration = op.attributes().getAttrBool("reshuffle_each_iteration");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private Boolean reshuffleEachIteration;
        private String metadata;

        private Options() {
        }

        public Options reshuffleEachIteration(Boolean reshuffleEachIteration) {
            this.reshuffleEachIteration = reshuffleEachIteration;
            return this;
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

