/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="MapAndBatchDataset", inputsClass=Inputs.class)
public final class MapAndBatchDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "MapAndBatchDataset";
    private Output<? extends TType> handle;

    public MapAndBatchDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static MapAndBatchDataset create(Scope scope, Operand<? extends TType> inputDataset, Iterable<Operand<?>> otherArguments, Operand<TInt64> batchSize, Operand<TInt64> numParallelCalls, Operand<TBool> dropRemainder, ConcreteFunction f, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInputList(Operands.asOutputs(otherArguments));
        opBuilder.addInput(batchSize.asOutput());
        opBuilder.addInput(numParallelCalls.asOutput());
        opBuilder.addInput(dropRemainder.asOutput());
        opBuilder.setAttr("f", f);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.preserveCardinality != null) {
                    opBuilder.setAttr("preserve_cardinality", opts.preserveCardinality);
                }
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new MapAndBatchDataset(opBuilder.build());
    }

    public static Options preserveCardinality(Boolean preserveCardinality) {
        return new Options().preserveCardinality(preserveCardinality);
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=MapAndBatchDataset.class)
    public static class Inputs
    extends RawOpInputs<MapAndBatchDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Iterable<Operand<?>> otherArguments;
        public final Operand<TInt64> batchSize;
        public final Operand<TInt64> numParallelCalls;
        public final Operand<TBool> dropRemainder;
        public final DataType[] Targuments;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final boolean preserveCardinality;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new MapAndBatchDataset(op), op, Arrays.asList("Targuments", "output_types", "output_shapes", "preserve_cardinality", "metadata"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            int otherArgumentsLength = op.inputListLength("other_arguments");
            this.otherArguments = Arrays.asList((Operand[])op.inputList(inputIndex, otherArgumentsLength));
            inputIndex += otherArgumentsLength;
            this.batchSize = op.input(inputIndex++);
            this.numParallelCalls = op.input(inputIndex++);
            this.dropRemainder = op.input(inputIndex++);
            this.Targuments = op.attributes().getAttrTypeList("Targuments");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.preserveCardinality = op.attributes().getAttrBool("preserve_cardinality");
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private Boolean preserveCardinality;
        private String metadata;

        private Options() {
        }

        public Options preserveCardinality(Boolean preserveCardinality) {
            this.preserveCardinality = preserveCardinality;
            return this;
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

