/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="InitializeTableFromTextFileV2", inputsClass=Inputs.class)
public final class InitializeTableFromTextFile
extends RawOp {
    public static final String OP_NAME = "InitializeTableFromTextFileV2";

    public InitializeTableFromTextFile(Operation operation) {
        super(operation, OP_NAME);
    }

    public static InitializeTableFromTextFile create(Scope scope, Operand<? extends TType> tableHandle, Operand<TString> filename, Long keyIndex, Long valueIndex, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "InitializeTableFromTextFile");
        opBuilder.addInput(tableHandle.asOutput());
        opBuilder.addInput(filename.asOutput());
        opBuilder.setAttr("key_index", keyIndex);
        opBuilder.setAttr("value_index", valueIndex);
        if (options != null) {
            for (Options opts : options) {
                if (opts.vocabSize != null) {
                    opBuilder.setAttr("vocab_size", opts.vocabSize);
                }
                if (opts.delimiter != null) {
                    opBuilder.setAttr("delimiter", opts.delimiter);
                }
                if (opts.offset == null) continue;
                opBuilder.setAttr("offset", opts.offset);
            }
        }
        return new InitializeTableFromTextFile(opBuilder.build());
    }

    public static Options vocabSize(Long vocabSize) {
        return new Options().vocabSize(vocabSize);
    }

    public static Options delimiter(String delimiter) {
        return new Options().delimiter(delimiter);
    }

    public static Options offset(Long offset) {
        return new Options().offset(offset);
    }

    @OpInputsMetadata(outputsClass=InitializeTableFromTextFile.class)
    public static class Inputs
    extends RawOpInputs<InitializeTableFromTextFile> {
        public final Operand<? extends TType> tableHandle;
        public final Operand<TString> filename;
        public final long keyIndex;
        public final long valueIndex;
        public final long vocabSize;
        public final String delimiter;
        public final long offset;

        public Inputs(GraphOperation op) {
            super(new InitializeTableFromTextFile(op), op, Arrays.asList("key_index", "value_index", "vocab_size", "delimiter", "offset"));
            int inputIndex = 0;
            this.tableHandle = op.input(inputIndex++);
            this.filename = op.input(inputIndex++);
            this.keyIndex = op.attributes().getAttrInt("key_index");
            this.valueIndex = op.attributes().getAttrInt("value_index");
            this.vocabSize = op.attributes().getAttrInt("vocab_size");
            this.delimiter = op.attributes().getAttrString("delimiter");
            this.offset = op.attributes().getAttrInt("offset");
        }
    }

    public static class Options {
        private Long vocabSize;
        private String delimiter;
        private Long offset;

        private Options() {
        }

        public Options vocabSize(Long vocabSize) {
            this.vocabSize = vocabSize;
            return this;
        }

        public Options delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Options offset(Long offset) {
            this.offset = offset;
            return this;
        }
    }
}

