/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="BatchToSpace", inputsClass=Inputs.class)
public final class BatchToSpace<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "BatchToSpace";
    private Output<T> output;

    public BatchToSpace(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> BatchToSpace<T> create(Scope scope, Operand<T> input, Operand<? extends TNumber> crops, Long blockSize) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(crops.asOutput());
        opBuilder.setAttr("block_size", blockSize);
        return new BatchToSpace<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=BatchToSpace.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<BatchToSpace<T>> {
        public final Operand<T> input;
        public final Operand<? extends TNumber> crops;
        public final DataType T;
        public final long blockSize;
        public final DataType Tidx;

        public Inputs(GraphOperation op) {
            super(new BatchToSpace(op), op, Arrays.asList("T", "block_size", "Tidx"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.crops = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.blockSize = op.attributes().getAttrInt("block_size");
            this.Tidx = op.attributes().getAttrType("Tidx");
        }
    }
}

