/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Assign", inputsClass=Inputs.class)
public final class Assign<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Assign";
    private Output<T> outputRef;

    public Assign(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputRef = operation.output(outputIdx++);
    }

    public static <T extends TType> Assign<T> create(Scope scope, Operand<T> ref, Operand<T> value, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(ref.asOutput());
        opBuilder.addInput(value.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.validateShape != null) {
                    opBuilder.setAttr("validate_shape", opts.validateShape);
                }
                if (opts.useLocking == null) continue;
                opBuilder.setAttr("use_locking", opts.useLocking);
            }
        }
        return new Assign<T>(opBuilder.build());
    }

    public static Options validateShape(Boolean validateShape) {
        return new Options().validateShape(validateShape);
    }

    public static Options useLocking(Boolean useLocking) {
        return new Options().useLocking(useLocking);
    }

    public Output<T> outputRef() {
        return this.outputRef;
    }

    @Override
    public Output<T> asOutput() {
        return this.outputRef;
    }

    @OpInputsMetadata(outputsClass=Assign.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Assign<T>> {
        public final Operand<T> ref;
        public final Operand<T> value;
        public final DataType T;
        public final boolean validateShape;
        public final boolean useLocking;

        public Inputs(GraphOperation op) {
            super(new Assign(op), op, Arrays.asList("T", "validate_shape", "use_locking"));
            int inputIndex = 0;
            this.ref = op.input(inputIndex++);
            this.value = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.validateShape = op.attributes().getAttrBool("validate_shape");
            this.useLocking = op.attributes().getAttrBool("use_locking");
        }
    }

    public static class Options {
        private Boolean validateShape;
        private Boolean useLocking;

        private Options() {
        }

        public Options validateShape(Boolean validateShape) {
            this.validateShape = validateShape;
            return this;
        }

        public Options useLocking(Boolean useLocking) {
            this.useLocking = useLocking;
            return this;
        }
    }
}

