/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.Operand;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.tpu.CollateTPUEmbeddingMemory;
import org.tensorflow.op.tpu.Compile;
import org.tensorflow.op.tpu.CompileSucceededAssert;
import org.tensorflow.op.tpu.ConfigureAndInitializeGlobalTPU;
import org.tensorflow.op.tpu.ConfigureTPUEmbeddingHost;
import org.tensorflow.op.tpu.ConfigureTPUEmbeddingMemory;
import org.tensorflow.op.tpu.ConnectTPUEmbeddingHosts;
import org.tensorflow.op.tpu.DTensorRestore;
import org.tensorflow.op.tpu.DTensorShardedPrefix;
import org.tensorflow.op.tpu.Execute;
import org.tensorflow.op.tpu.ExecuteAndUpdateVariables;
import org.tensorflow.op.tpu.ExecuteTPUEmbeddingPartitioner;
import org.tensorflow.op.tpu.FinalizeTPUEmbedding;
import org.tensorflow.op.tpu.PartitionedInput;
import org.tensorflow.op.tpu.PartitionedOutput;
import org.tensorflow.op.tpu.ShutdownTPUSystem;
import org.tensorflow.op.tpu.TPURoundRobin;
import org.tensorflow.op.tpu.TpuHandleToProtoKey;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

public final class TpuOps {
    private final Scope scope;
    private final Ops ops;

    TpuOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public CollateTPUEmbeddingMemory collateTPUEmbeddingMemory(Iterable<Operand<TString>> memoryConfigs) {
        return CollateTPUEmbeddingMemory.create(this.scope, memoryConfigs);
    }

    public Compile compile(Iterable<Operand<TInt64>> dynamicShapes, Iterable<Operand<?>> guaranteedConstants, Long numComputations, ConcreteFunction function, String metadata) {
        return Compile.create(this.scope, dynamicShapes, guaranteedConstants, numComputations, function, metadata);
    }

    public CompileSucceededAssert compileSucceededAssert(Operand<TString> compilationStatus) {
        return CompileSucceededAssert.create(this.scope, compilationStatus);
    }

    public ConfigureAndInitializeGlobalTPU configureAndInitializeGlobalTPU() {
        return ConfigureAndInitializeGlobalTPU.create(this.scope);
    }

    public ConfigureTPUEmbeddingHost configureTPUEmbeddingHost(Operand<TString> commonConfig, Operand<TString> memoryConfig, String config) {
        return ConfigureTPUEmbeddingHost.create(this.scope, commonConfig, memoryConfig, config);
    }

    public ConfigureTPUEmbeddingMemory configureTPUEmbeddingMemory(Operand<TString> commonConfig) {
        return ConfigureTPUEmbeddingMemory.create(this.scope, commonConfig);
    }

    public ConnectTPUEmbeddingHosts connectTPUEmbeddingHosts(Iterable<Operand<TString>> networkConfigs) {
        return ConnectTPUEmbeddingHosts.create(this.scope, networkConfigs);
    }

    public DTensorRestore dTensorRestore(Operand<TString> prefix, Operand<TString> tensorNames, Operand<TString> shapeAndSlices, List<Shape> inputShapes, List<String> inputLayouts, List<Class<? extends TType>> dtypes) {
        return DTensorRestore.create(this.scope, prefix, tensorNames, shapeAndSlices, inputShapes, inputLayouts, dtypes);
    }

    public DTensorShardedPrefix dTensorShardedPrefix(Operand<TString> prefix, Operand<TString> tensorNames, Operand<TString> shapeAndSlices, Operand<TString> mesh, Operand<TString> layouts, Iterable<Operand<?>> tensors) {
        return DTensorShardedPrefix.create(this.scope, prefix, tensorNames, shapeAndSlices, mesh, layouts, tensors);
    }

    public Execute execute(Iterable<Operand<?>> args, Operand<TString> key, List<Class<? extends TType>> Tresults) {
        return Execute.create(this.scope, args, key, Tresults);
    }

    public ExecuteAndUpdateVariables executeAndUpdateVariables(Iterable<Operand<?>> args, Operand<TString> key, List<Class<? extends TType>> Tresults, List<Long> deviceVarReadsIndices, List<Long> deviceVarUpdatesIndices) {
        return ExecuteAndUpdateVariables.create(this.scope, args, key, Tresults, deviceVarReadsIndices, deviceVarUpdatesIndices);
    }

    public ExecuteTPUEmbeddingPartitioner executeTPUEmbeddingPartitioner(String config) {
        return ExecuteTPUEmbeddingPartitioner.create(this.scope, config);
    }

    public FinalizeTPUEmbedding finalizeTPUEmbedding(Operand<TString> commonConfig, Operand<TString> memoryConfig) {
        return FinalizeTPUEmbedding.create(this.scope, commonConfig, memoryConfig);
    }

    public <T extends TType> PartitionedInput<T> partitionedInput(Iterable<Operand<T>> inputs, PartitionedInput.Options ... options) {
        return PartitionedInput.create(this.scope, inputs, options);
    }

    public <T extends TType> PartitionedOutput<T> partitionedOutput(Operand<T> inputs, Long numSplits, PartitionedOutput.Options ... options) {
        return PartitionedOutput.create(this.scope, inputs, numSplits, options);
    }

    public ShutdownTPUSystem shutdownTPUSystem() {
        return ShutdownTPUSystem.create(this.scope);
    }

    public TPURoundRobin tPURoundRobin() {
        return TPURoundRobin.create(this.scope);
    }

    public TpuHandleToProtoKey tpuHandleToProtoKey(Operand<TInt64> uid) {
        return TpuHandleToProtoKey.create(this.scope, uid);
    }

    public final Ops ops() {
        return this.ops;
    }
}

