/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.random.AllCandidateSampler;
import org.tensorflow.op.random.LogUniformCandidateSampler;
import org.tensorflow.op.random.Multinomial;
import org.tensorflow.op.random.ParameterizedTruncatedNormal;
import org.tensorflow.op.random.RandomGamma;
import org.tensorflow.op.random.RandomPoisson;
import org.tensorflow.op.random.RandomShuffle;
import org.tensorflow.op.random.RandomStandardNormal;
import org.tensorflow.op.random.RandomUniform;
import org.tensorflow.op.random.RandomUniformInt;
import org.tensorflow.op.random.RecordInput;
import org.tensorflow.op.random.StatefulRandomBinomial;
import org.tensorflow.op.random.StatefulStandardNormal;
import org.tensorflow.op.random.StatelessMultinomial;
import org.tensorflow.op.random.StatelessRandomNormal;
import org.tensorflow.op.random.StatelessRandomUniform;
import org.tensorflow.op.random.StatelessTruncatedNormal;
import org.tensorflow.op.random.TruncatedNormal;
import org.tensorflow.op.random.UniformCandidateSampler;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class RandomOps {
    private final Scope scope;
    private final Ops ops;

    RandomOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public AllCandidateSampler allCandidateSampler(Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, AllCandidateSampler.Options ... options) {
        return AllCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, options);
    }

    public LogUniformCandidateSampler logUniformCandidateSampler(Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, LogUniformCandidateSampler.Options ... options) {
        return LogUniformCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }

    public Multinomial<TInt64> multinomial(Operand<? extends TNumber> logits, Operand<TInt32> numSamples, Multinomial.Options[] options) {
        return Multinomial.create(this.scope, logits, numSamples, options);
    }

    public <U extends TNumber> Multinomial<U> multinomial(Operand<? extends TNumber> logits, Operand<TInt32> numSamples, Class<U> outputDtype, Multinomial.Options ... options) {
        return Multinomial.create(this.scope, logits, numSamples, outputDtype, options);
    }

    public <U extends TNumber> ParameterizedTruncatedNormal<U> parameterizedTruncatedNormal(Operand<? extends TNumber> shape, Operand<U> means, Operand<U> stdevs, Operand<U> minvals, Operand<U> maxvals, ParameterizedTruncatedNormal.Options ... options) {
        return ParameterizedTruncatedNormal.create(this.scope, shape, means, stdevs, minvals, maxvals, options);
    }

    public <U extends TNumber> RandomGamma<U> randomGamma(Operand<? extends TNumber> shape, Operand<U> alpha, RandomGamma.Options ... options) {
        return RandomGamma.create(this.scope, shape, alpha, options);
    }

    public RandomPoisson<TInt64> randomPoisson(Operand<? extends TNumber> shape, Operand<? extends TNumber> rate, RandomPoisson.Options[] options) {
        return RandomPoisson.create(this.scope, shape, rate, options);
    }

    public <V extends TNumber> RandomPoisson<V> randomPoisson(Operand<? extends TNumber> shape, Operand<? extends TNumber> rate, Class<V> dtype, RandomPoisson.Options ... options) {
        return RandomPoisson.create(this.scope, shape, rate, dtype, options);
    }

    public <T extends TType> RandomShuffle<T> randomShuffle(Operand<T> value, RandomShuffle.Options ... options) {
        return RandomShuffle.create(this.scope, value, options);
    }

    public <U extends TNumber> RandomStandardNormal<U> randomStandardNormal(Operand<? extends TNumber> shape, Class<U> dtype, RandomStandardNormal.Options ... options) {
        return RandomStandardNormal.create(this.scope, shape, dtype, options);
    }

    public <U extends TNumber> RandomUniform<U> randomUniform(Operand<? extends TNumber> shape, Class<U> dtype, RandomUniform.Options ... options) {
        return RandomUniform.create(this.scope, shape, dtype, options);
    }

    public <U extends TNumber> RandomUniformInt<U> randomUniformInt(Operand<? extends TNumber> shape, Operand<U> minval, Operand<U> maxval, RandomUniformInt.Options ... options) {
        return RandomUniformInt.create(this.scope, shape, minval, maxval, options);
    }

    public RecordInput recordInput(String filePattern, RecordInput.Options ... options) {
        return RecordInput.create(this.scope, filePattern, options);
    }

    public <U extends TNumber> StatefulRandomBinomial<TInt64> statefulRandomBinomial(Operand<? extends TType> resource, Operand<TInt64> algorithm, Operand<? extends TNumber> shape, Operand<U> counts, Operand<U> probs) {
        return StatefulRandomBinomial.create(this.scope, resource, algorithm, shape, counts, probs);
    }

    public <V extends TNumber, U extends TNumber> StatefulRandomBinomial<V> statefulRandomBinomial(Operand<? extends TType> resource, Operand<TInt64> algorithm, Operand<? extends TNumber> shape, Operand<U> counts, Operand<U> probs, Class<V> dtype) {
        return StatefulRandomBinomial.create(this.scope, resource, algorithm, shape, counts, probs, dtype);
    }

    public StatefulStandardNormal<TFloat32> statefulStandardNormal(Operand<? extends TType> resource, Operand<TInt64> algorithm, Operand<? extends TType> shape) {
        return StatefulStandardNormal.create(this.scope, resource, algorithm, shape);
    }

    public <U extends TType> StatefulStandardNormal<U> statefulStandardNormal(Operand<? extends TType> resource, Operand<TInt64> algorithm, Operand<? extends TType> shape, Class<U> dtype) {
        return StatefulStandardNormal.create(this.scope, resource, algorithm, shape, dtype);
    }

    public StatelessMultinomial<TInt64> statelessMultinomial(Operand<? extends TNumber> logits, Operand<TInt32> numSamples, Operand<? extends TNumber> seed) {
        return StatelessMultinomial.create(this.scope, logits, numSamples, seed);
    }

    public <V extends TNumber> StatelessMultinomial<V> statelessMultinomial(Operand<? extends TNumber> logits, Operand<TInt32> numSamples, Operand<? extends TNumber> seed, Class<V> outputDtype) {
        return StatelessMultinomial.create(this.scope, logits, numSamples, seed, outputDtype);
    }

    public StatelessRandomNormal<TFloat32> statelessRandomNormal(Operand<? extends TNumber> shape, Operand<? extends TNumber> seed) {
        return StatelessRandomNormal.create(this.scope, shape, seed);
    }

    public <V extends TNumber> StatelessRandomNormal<V> statelessRandomNormal(Operand<? extends TNumber> shape, Operand<? extends TNumber> seed, Class<V> dtype) {
        return StatelessRandomNormal.create(this.scope, shape, seed, dtype);
    }

    public StatelessRandomUniform<TFloat32> statelessRandomUniform(Operand<? extends TNumber> shape, Operand<? extends TNumber> seed) {
        return StatelessRandomUniform.create(this.scope, shape, seed);
    }

    public <V extends TNumber> StatelessRandomUniform<V> statelessRandomUniform(Operand<? extends TNumber> shape, Operand<? extends TNumber> seed, Class<V> dtype) {
        return StatelessRandomUniform.create(this.scope, shape, seed, dtype);
    }

    public StatelessTruncatedNormal<TFloat32> statelessTruncatedNormal(Operand<? extends TNumber> shape, Operand<? extends TNumber> seed) {
        return StatelessTruncatedNormal.create(this.scope, shape, seed);
    }

    public <V extends TNumber> StatelessTruncatedNormal<V> statelessTruncatedNormal(Operand<? extends TNumber> shape, Operand<? extends TNumber> seed, Class<V> dtype) {
        return StatelessTruncatedNormal.create(this.scope, shape, seed, dtype);
    }

    public <U extends TNumber> TruncatedNormal<U> truncatedNormal(Operand<? extends TNumber> shape, Class<U> dtype, TruncatedNormal.Options ... options) {
        return TruncatedNormal.create(this.scope, shape, dtype, options);
    }

    public UniformCandidateSampler uniformCandidateSampler(Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, UniformCandidateSampler.Options ... options) {
        return UniformCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }

    public final Ops ops() {
        return this.ops;
    }
}

