/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer.raw;

import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.buffer.FloatDataBuffer;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.ndarray.buffer.ShortDataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;
import org.tensorflow.ndarray.impl.buffer.raw.BooleanRawDataBuffer;
import org.tensorflow.ndarray.impl.buffer.raw.ByteRawDataBuffer;
import org.tensorflow.ndarray.impl.buffer.raw.DoubleRawDataBuffer;
import org.tensorflow.ndarray.impl.buffer.raw.FloatRawDataBuffer;
import org.tensorflow.ndarray.impl.buffer.raw.IntRawDataBuffer;
import org.tensorflow.ndarray.impl.buffer.raw.LongRawDataBuffer;
import org.tensorflow.ndarray.impl.buffer.raw.ShortRawDataBuffer;
import org.tensorflow.ndarray.impl.buffer.raw.UnsafeMemoryHandle;
import org.tensorflow.ndarray.impl.buffer.raw.UnsafeReference;

public class RawDataBufferFactory {
    static long MAX_32BITS = 0x7FFFFFF5L;
    static long MAX_64BITS = 0x7FFFFFFFFFFFFFF5L;

    public static boolean canBeUsed() {
        return UnsafeReference.isAvailable();
    }

    public static BooleanDataBuffer create(boolean[] array, boolean readOnly) {
        return new BooleanRawDataBuffer(UnsafeMemoryHandle.fromArray(array, array.length), readOnly);
    }

    public static ByteDataBuffer create(byte[] array, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        return new ByteRawDataBuffer(UnsafeMemoryHandle.fromArray(array, array.length), readOnly);
    }

    public static DoubleDataBuffer create(double[] array, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        return new DoubleRawDataBuffer(UnsafeMemoryHandle.fromArray(array, array.length), readOnly);
    }

    public static FloatDataBuffer create(float[] array, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        return new FloatRawDataBuffer(UnsafeMemoryHandle.fromArray(array, array.length), readOnly);
    }

    public static IntDataBuffer create(int[] array, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        return new IntRawDataBuffer(UnsafeMemoryHandle.fromArray(array, array.length), readOnly);
    }

    public static LongDataBuffer create(long[] array, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        return new LongRawDataBuffer(UnsafeMemoryHandle.fromArray(array, array.length), readOnly);
    }

    public static ShortDataBuffer create(short[] array, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        return new ShortRawDataBuffer(UnsafeMemoryHandle.fromArray(array, array.length), readOnly);
    }

    protected static BooleanDataBuffer mapNativeBooleans(long address, long size, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        Validator.createArgs(size, MAX_64BITS);
        return new BooleanRawDataBuffer(UnsafeMemoryHandle.fromAddress(address, size, 1L), readOnly);
    }

    protected static ByteDataBuffer mapNativeBytes(long address, long size, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        Validator.createArgs(size, MAX_64BITS);
        return new ByteRawDataBuffer(UnsafeMemoryHandle.fromAddress(address, size, 1L), readOnly);
    }

    protected static DoubleDataBuffer mapNativeDoubles(long address, long size, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        Validator.createArgs(size, MAX_64BITS);
        return new DoubleRawDataBuffer(UnsafeMemoryHandle.fromAddress(address, size, 8L), readOnly);
    }

    protected static FloatDataBuffer mapNativeFloats(long address, long size, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        Validator.createArgs(size, MAX_64BITS);
        return new FloatRawDataBuffer(UnsafeMemoryHandle.fromAddress(address, size, 4L), readOnly);
    }

    protected static IntDataBuffer mapNativeInts(long address, long size, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        Validator.createArgs(size, MAX_64BITS);
        return new IntRawDataBuffer(UnsafeMemoryHandle.fromAddress(address, size, 4L), readOnly);
    }

    protected static LongDataBuffer mapNativeLongs(long address, long size, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        Validator.createArgs(size, MAX_64BITS);
        return new LongRawDataBuffer(UnsafeMemoryHandle.fromAddress(address, size, 8L), readOnly);
    }

    protected static ShortDataBuffer mapNativeShorts(long address, long size, boolean readOnly) {
        if (!RawDataBufferFactory.canBeUsed()) {
            throw new IllegalStateException("Raw data buffers are not available");
        }
        Validator.createArgs(size, MAX_64BITS);
        return new ShortRawDataBuffer(UnsafeMemoryHandle.fromAddress(address, size, 2L), readOnly);
    }
}

