/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.c_api.presets;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.bytedeco.javacpp.ClassProperties;
import org.bytedeco.javacpp.LoadEnabled;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.annotation.Adapter;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.NoException;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.tools.Info;
import org.bytedeco.javacpp.tools.InfoMap;
import org.bytedeco.javacpp.tools.InfoMapper;

@Properties(value={@Platform(value={"linux", "macosx", "windows"}, compiler={"cpp14"}, include={"tensorflow/core/platform/ctstring_internal.h", "tensorflow/core/platform/ctstring.h", "tensorflow/core/util/port.h", "tensorflow/c/tf_attrtype.h", "tensorflow/c/c_api_macros.h", "tensorflow/c/tf_datatype.h", "tensorflow/c/tf_status.h", "tensorflow/c/tf_tensor.h", "tensorflow/c/tf_tstring.h", "tensorflow/c/c_api.h", "tensorflow/c/kernels.h", "tensorflow/c/ops.h", "tensorflow_adapters.h", "tensorflow/c/eager/c_api.h", "tensorflow/c/eager/c_api_experimental.h", "tensorflow/cc/framework/scope.h", "tensorflow/cc/framework/grad_op_registry.h", "tensorflow/core/platform/status.h", "tensorflow/core/graph/graph.h", "tensorflow/c/tf_status_helper.h", "tensorflow/cc/framework/ops.h", "tensorflow/c/c_api_internal.h"}, link={"tensorflow_cc@.2", "tensorflow_framework@.2"}, preload={"iomp5", "mklml", "mklml_intel"}, preloadresource={"/org/bytedeco/mkldnn/"}, resource={"LICENSE", "THIRD_PARTY_TF_JNI_LICENSES"}), @Platform(value={"windows"}, preload={"api-ms-win-crt-locale-l1-1-0", "api-ms-win-crt-string-l1-1-0", "api-ms-win-crt-stdio-l1-1-0", "api-ms-win-crt-math-l1-1-0", "api-ms-win-crt-heap-l1-1-0", "api-ms-win-crt-runtime-l1-1-0", "api-ms-win-crt-convert-l1-1-0", "api-ms-win-crt-environment-l1-1-0", "api-ms-win-crt-time-l1-1-0", "api-ms-win-crt-filesystem-l1-1-0", "api-ms-win-crt-utility-l1-1-0", "api-ms-win-crt-multibyte-l1-1-0", "api-ms-win-core-string-l1-1-0", "api-ms-win-core-errorhandling-l1-1-0", "api-ms-win-core-timezone-l1-1-0", "api-ms-win-core-file-l1-1-0", "api-ms-win-core-namedpipe-l1-1-0", "api-ms-win-core-handle-l1-1-0", "api-ms-win-core-file-l2-1-0", "api-ms-win-core-heap-l1-1-0", "api-ms-win-core-libraryloader-l1-1-0", "api-ms-win-core-synch-l1-1-0", "api-ms-win-core-processthreads-l1-1-0", "api-ms-win-core-processenvironment-l1-1-0", "api-ms-win-core-datetime-l1-1-0", "api-ms-win-core-localization-l1-2-0", "api-ms-win-core-sysinfo-l1-1-0", "api-ms-win-core-synch-l1-2-0", "api-ms-win-core-console-l1-1-0", "api-ms-win-core-debug-l1-1-0", "api-ms-win-core-rtlsupport-l1-1-0", "api-ms-win-core-processthreads-l1-1-1", "api-ms-win-core-file-l1-2-0", "api-ms-win-core-profile-l1-1-0", "api-ms-win-core-memory-l1-1-0", "api-ms-win-core-util-l1-1-0", "api-ms-win-core-interlocked-l1-1-0", "ucrtbase", "vcruntime140", "vcruntime140_1", "msvcp140", "concrt140", "vcomp140", "msvcr120", "libiomp5md", "mklml", "tensorflow_framework"}, link={"tensorflow_cc@.2"}), @Platform(value={"windows-x86"}, preloadpath={"C:/Program Files (x86)/Microsoft Visual Studio 14.0/VC/redist/x86/Microsoft.VC140.CRT/", "C:/Program Files (x86)/Microsoft Visual Studio 14.0/VC/redist/x86/Microsoft.VC140.OpenMP/", "C:/Program Files (x86)/Windows Kits/10/Redist/ucrt/DLLs/x86/"}), @Platform(value={"windows-x86_64"}, preloadpath={"C:/Program Files (x86)/Microsoft Visual Studio 14.0/VC/redist/x64/Microsoft.VC140.CRT/", "C:/Program Files (x86)/Microsoft Visual Studio 14.0/VC/redist/x64/Microsoft.VC140.OpenMP/", "C:/Program Files (x86)/Windows Kits/10/Redist/ucrt/DLLs/x64/"}), @Platform(value={"linux", "macosx", "windows"}, extension={"-mkl", "-gpu", "-mkl-gpu"})}, target="org.tensorflow.internal.c_api", global="org.tensorflow.internal.c_api.global.tensorflow")
@NoException
public class tensorflow
implements LoadEnabled,
InfoMapper {
    /*
     * WARNING - void declaration
     */
    public void init(ClassProperties properties) {
        String[] libs;
        String platform = properties.getProperty("platform");
        String extension = properties.getProperty("platform.extension");
        List preloads = properties.get("platform.preload");
        List resources = properties.get("platform.preloadresource");
        List preloadpaths = properties.get("platform.preloadpath");
        String vcredistdir = System.getenv("VCToolsRedistDir");
        if (vcredistdir != null && vcredistdir.length() > 0) {
            switch (platform) {
                case "windows-x86": {
                    preloadpaths.add(0, vcredistdir + "\\x86\\Microsoft.VC142.CRT");
                    preloadpaths.add(1, vcredistdir + "\\x86\\Microsoft.VC142.OpenMP");
                    preloadpaths.add(2, vcredistdir + "\\x86\\Microsoft.VC141.CRT");
                    preloadpaths.add(3, vcredistdir + "\\x86\\Microsoft.VC141.OpenMP");
                    break;
                }
                case "windows-x86_64": {
                    preloadpaths.add(0, vcredistdir + "\\x64\\Microsoft.VC142.CRT");
                    preloadpaths.add(1, vcredistdir + "\\x64\\Microsoft.VC142.OpenMP");
                    preloadpaths.add(2, vcredistdir + "\\x64\\Microsoft.VC141.CRT");
                    preloadpaths.add(3, vcredistdir + "\\x64\\Microsoft.VC141.OpenMP");
                    break;
                }
            }
        }
        if (!Loader.isLoadLibraries()) {
            return;
        }
        String load = System.getProperty("org.bytedeco.openblas.load", System.getProperty("org.bytedeco.mklml.load", "")).toLowerCase();
        int i = 0;
        if (load.equals("mkl") || load.equals("mkl_rt")) {
            libs = new String[]{"iomp5", "libiomp5md", "mkl_core", "mkl_avx", "mkl_avx2", "mkl_avx512", "mkl_avx512_mic", "mkl_def", "mkl_mc", "mkl_mc3", "mkl_intel_lp64", "mkl_intel_thread", "mkl_gnu_thread", "mkl_rt"};
            for (i = 0; i < libs.length; ++i) {
                preloads.add(i, libs[i] + "#" + libs[i]);
            }
            load = "mkl_rt";
            resources.add("/org/bytedeco/mkl/");
        }
        if (load.length() > 0) {
            if (platform.startsWith("linux")) {
                preloads.add(i, load + "#mklml_intel");
            } else if (platform.startsWith("macosx")) {
                preloads.add(i, load + "#mklml");
            } else if (platform.startsWith("windows")) {
                preloads.add(i, load + "#mklml");
            }
        }
        if (!Loader.isLoadLibraries() || extension == null || !extension.endsWith("-gpu")) {
            return;
        }
        for (String string : libs = new String[]{"cudart", "cublasLt", "cublas", "cufft", "curand", "cusolver", "cusparse", "cudnn", "nccl", "nvrtc", "myelin", "nvinfer", "cudnn_ops_infer", "cudnn_ops_train", "cudnn_adv_infer", "cudnn_adv_train", "cudnn_cnn_infer", "cudnn_cnn_train"}) {
            void var14_18;
            if (platform.startsWith("linux")) {
                String string2 = string + (string.startsWith("cudnn") ? "@.8" : (string.equals("nccl") ? "@.2" : (string.equals("myelin") ? "@.1" : (string.equals("nvinfer") ? "@.7" : (string.equals("cufft") || string.equals("curand") || string.equals("cusolver") ? "@.10" : (string.equals("cudart") ? "@.11.0" : (string.equals("nvrtc") ? "@.11.0" : "@.11")))))));
            } else {
                if (!platform.startsWith("windows")) continue;
                String string3 = string + (string.startsWith("cudnn") ? "64_8" : (string.equals("nccl") ? "64_2" : (string.equals("myelin") ? "64_1" : (string.equals("nvinfer") ? "64_7" : (string.equals("cufft") || string.equals("curand") || string.equals("cusolver") ? "64_10" : (string.equals("cudart") ? "64_110" : (string.equals("nvrtc") ? "64_110_0" : "64_11")))))));
            }
            if (preloads.contains(var14_18)) continue;
            preloads.add(i++, var14_18);
        }
        if (i > 0) {
            resources.add("/org/bytedeco/cuda/");
            resources.add("/org/bytedeco/tensorrt/");
        }
    }

    public void map(InfoMap infoMap) {
        infoMap.put(new Info(new String[]{"c_api_internal.h"}).linePatterns(new String[]{"struct TF_OperationDescription \\{", "\\};", "struct TF_Graph \\{", "\\};", "struct TF_Operation \\{", "\\};", "// Exposed helper functions", "// End Exposed helper functions"})).put(new Info(new String[]{"graph.h"}).linePatterns(new String[]{"class Node \\{", "// Stores debug information associated with the Node."})).put(new Info(new String[]{"Node"}).cppTypes(new String[]{"tensorflow::Node"}).purify()).put(new Info(new String[]{"tensorflow::NodeDef", "tensorflow::OpDef", "tensorflow::AttrSlice", "tensorflow::Edge", "tensorflow::EdgeSet", "tensorflow::WhileContext", "tensorflow::NodeProperties", "protobuf::RepeatedPtrField", "gtl::iterator_range<NeighborIter>", "tensorflow::DataType", "tensorflow::DataTypeVector", "tensorflow::Node::set_original_func_names", "tensorflow::Node::set_original_node_names", "tensorflow::Node::AddAttr", "tensorflow::Node::ClearAttr", "tensorflow::Node::input_node", "tensorflow::Node::RunForwardTypeInference"}).skip()).put(new Info(new String[]{"c_api.cc"}).linePatterns(new String[]{"// Helper functions -+", "// Shape functions -+", "static TF_OperationDescription\\* TF_NewOperationLocked\\(TF_Graph\\* graph,", "\\}", "static TF_Operation\\* TF_FinishOperationLocked\\(TF_OperationDescription\\* desc,", "\\}"})).put(new Info(new String[]{"OutputTensor", "TensorId", "tensorflow::AttrValue"}).skip()).put(new Info(new String[]{"c_api_experimental.h"}).linePatterns(new String[]{"typedef struct TFE_OpAttrs TFE_OpAttrs;", "#define TFE_CUSTOM_DEVICE_VERSION 4"})).put(new Info(new String[]{"TF_CAPI_EXPORT", "TF_Bool", "TF_GUARDED_BY", "TF_MUST_USE_RESULT"}).cppTypes(new String[0]).annotations(new String[0])).put(new Info(new String[]{"TF_DISALLOW_COPY_AND_ASSIGN"}).skip()).put(new Info(new String[]{"TF_Buffer::data"}).javaText("public native @Const Pointer data(); public native TF_Buffer data(Pointer data);")).put(new Info(new String[]{"TF_Status"}).pointerTypes(new String[]{"TF_Status"}).base("org.tensorflow.internal.c_api.AbstractTF_Status")).put(new Info(new String[]{"TF_Buffer"}).pointerTypes(new String[]{"TF_Buffer"}).base("org.tensorflow.internal.c_api.AbstractTF_Buffer")).put(new Info(new String[]{"TF_Tensor"}).pointerTypes(new String[]{"TF_Tensor"}).base("org.tensorflow.internal.c_api.AbstractTF_Tensor")).put(new Info(new String[]{"TF_Session"}).pointerTypes(new String[]{"TF_Session"}).base("org.tensorflow.internal.c_api.AbstractTF_Session")).put(new Info(new String[]{"TF_SessionOptions"}).pointerTypes(new String[]{"TF_SessionOptions"}).base("org.tensorflow.internal.c_api.AbstractTF_SessionOptions")).put(new Info(new String[]{"TF_Graph"}).pointerTypes(new String[]{"TF_Graph"}).base("org.tensorflow.internal.c_api.AbstractTF_Graph").purify()).put(new Info(new String[]{"tensorflow::Graph"}).javaNames(new String[]{"NativeGraphPointer"})).put(new Info(new String[]{"TF_Graph::graph"}).javaText("public native @MemberGetter @ByRef NativeGraphPointer graph();")).put(new Info(new String[]{"TF_Graph::refiner", "TF_Graph::mu", "TF_Graph::sessions", "TF_Graph::delete_requested"}).skip()).put(new Info(new String[]{"std::unordered_map<tensorflow::string,tensorflow::Node*>"}).pointerTypes(new String[]{"NameMap"}).define().javaText("public native long erase(@StdString BytePointer key);")).put(new Info(new String[]{"TF_Function"}).pointerTypes(new String[]{"TF_Function"}).base("org.tensorflow.internal.c_api.AbstractTF_Function")).put(new Info(new String[]{"TF_ImportGraphDefOptions"}).pointerTypes(new String[]{"TF_ImportGraphDefOptions"}).base("org.tensorflow.internal.c_api.AbstractTF_ImportGraphDefOptions")).put(new Info(new String[]{"TF_WhileParams"}).purify()).put(new Info(new String[]{"TF_Operation"}).purify()).put(new Info(new String[]{"TF_Operation::node"}).javaText("public native @MemberGetter @ByRef Node node();")).put(new Info(new String[]{"TFE_Context"}).pointerTypes(new String[]{"TFE_Context"}).base("org.tensorflow.internal.c_api.AbstractTFE_Context")).put(new Info(new String[]{"TFE_ContextOptions"}).pointerTypes(new String[]{"TFE_ContextOptions"}).base("org.tensorflow.internal.c_api.AbstractTFE_ContextOptions")).put(new Info(new String[]{"TFE_Context::context"}).javaText("@MemberGetter public native @ByRef EagerContext context();")).put(new Info(new String[]{"TFE_Op"}).pointerTypes(new String[]{"TFE_Op"}).base("org.tensorflow.internal.c_api.AbstractTFE_Op")).put(new Info(new String[]{"TFE_Op::operation"}).javaText("@MemberGetter public native @ByRef EagerOperation operation();")).put(new Info(new String[]{"TFE_TensorHandle"}).pointerTypes(new String[]{"TFE_TensorHandle"}).base("org.tensorflow.internal.c_api.AbstractTFE_TensorHandle")).put(new Info(new String[]{"SP_Stream"}).cast().pointerTypes(new String[]{"Pointer"})).put(new Info(new String[]{"TF_ShapeInferenceContextDimValueKnown", "TFE_NewTensorHandle(const tensorflow::Tensor&, TF_Status*)", "TF_InitKernel", "TFE_MonitoringCounterCell", "TFE_MonitoringCounter0", "TFE_MonitoringCounter1", "TFE_MonitoringCounter2", "TFE_MonitoringIntGaugeCell", "TFE_MonitoringIntGauge0", "TFE_MonitoringIntGauge1", "TFE_MonitoringIntGauge2", "TFE_MonitoringStringGaugeCell", "TFE_MonitoringStringGauge0", "TFE_MonitoringStringGauge1", "TFE_MonitoringStringGauge2", "TFE_MonitoringBoolGaugeCell", "TFE_MonitoringBoolGauge0", "TFE_MonitoringBoolGauge1", "TFE_MonitoringBoolGauge2", "TFE_MonitoringSamplerCell", "TFE_MonitoringSampler0", "TFE_MonitoringSampler1", "TFE_MonitoringSampler2", "TFE_CustomDeviceTensorHandle", "TFE_CustomDevice"}).skip()).put(new Info(new String[]{"TF_OperationDescription"}).pointerTypes(new String[]{"TF_OperationDescription"}).purify()).put(new Info(new String[]{"tensorflow::Scope"}).javaNames(new String[]{"TF_Scope"})).put(new Info(new String[]{"tensorflow::NodeBuilder"}).pointerTypes(new String[]{"NodeBuilder"})).put(new Info(new String[]{"string", "tensorflow::string"}).annotations(new String[]{"@StdString"}).valueTypes(new String[]{"BytePointer", "String"}).pointerTypes(new String[]{"BytePointer"})).put(new Info(new String[]{"absl::Span", "tensorflow::gtl::ArraySlice"}).annotations(new String[]{"@Span"})).put(new Info(new String[]{"absl::Span<const tensorflow::SourceLocation>"}).annotations(new String[]{"@Span"}).valueTypes(new String[]{"@Cast(\"const tensorflow::SourceLocation*\") SourceLocation"}).pointerTypes(new String[]{"SourceLocation"})).put(new Info(new String[]{"std::vector<tensorflow::Output>"}).pointerTypes(new String[]{"NativeOutputVector"}).define()).put(new Info(new String[]{"tensorflow::Output"}).javaNames(new String[]{"NativeOutput"})).put(new Info(new String[]{"tensorflow::Operation"}).javaNames(new String[]{"NativeOperation"})).put(new Info(new String[]{"tensorflow::Status"}).javaNames(new String[]{"NativeStatus"}).purify()).put(new Info(new String[]{"tensorflow::int32", "tensorflow::error::Code"}).cast().valueTypes(new String[]{"int"}).pointerTypes(new String[]{"IntPointer", "IntBuffer", "int[]"})).put(new Info(new String[]{"tensorflow::CompositeOpScopes", "tensorflow::Input", "tensorflow::InputList", "tensorflow::OutputHash", "tensorflow::StackFrame", "tensorflow::StatusGroup", "tensorflow::internal::TF_StatusDeleter", "tensorflow::GraphDef", "tensorflow::Scope::graph_as_shared_ptr", "tensorflow::Scope::ToGraphDef", "tensorflow::Scope::ToGraph", "tensorflow::Scope::DoShapeInference", "tensorflow::Scope::DisabledShapeInferenceScope", "tensorflow::Scope::control_deps", "tensorflow::Scope::WithKernelLabel", "tensorflow::Scope::ClearColocation", "tensorflow::Scope::ColocateWith", "tensorflow::Scope::ColocateWith", "tensorflow::Scope::WithXlaCluster", "tensorflow::Scope::WithAssignedDevice", "tensorflow::Scope::status", "tensorflow::Scope::UpdateStatus", "tensorflow::Status::code", "tensorflow::CreateOutputWithScope", "TF_OperationDescription::colocation_constraints", "tensorflow::Operation::num_inputs", "tensorflow::Operation::input_type", "tensorflow::Operation::input", "tensorflow::Operation::num_outputs", "tensorflow::Operation::output_type", "tensorflow::Operation::output", "tensorflow::Operation::hash", "tensorflow::Output::hash", "tensorflow::Output::type", "tensorflow::Status::GetAllPayloads", "tensorflow::Status::ReplaceAllPayloads", "tensorflow::Status::ErasePayload", "tensorflow::Status::SetPayload", "tensorflow::Status::GetPayload", "tensorflow::Status::ForEachPayload", "tensorflow::Node::SetStackTrace", "tensorflow::Node::GetStackTrace"}).skip());
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.PARAMETER})
    @Cast(value={"absl::Span", "&"})
    @Adapter(value="SpanAdapter")
    public static @interface Span {
        public String value() default "";
    }
}

