/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.PointerScope;
import org.bytedeco.javacpp.SizeTPointer;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.GraphOperation;
import org.tensorflow.GraphOperationBuilder;
import org.tensorflow.NativeFunction;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.exceptions.TensorFlowException;
import org.tensorflow.internal.c_api.NativeGraphPointer;
import org.tensorflow.internal.c_api.TF_Buffer;
import org.tensorflow.internal.c_api.TF_Function;
import org.tensorflow.internal.c_api.TF_Graph;
import org.tensorflow.internal.c_api.TF_ImportGraphDefOptions;
import org.tensorflow.internal.c_api.TF_Operation;
import org.tensorflow.internal.c_api.TF_Output;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.TF_WhileParams;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.op.Op;
import org.tensorflow.op.OpScope;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.Assign;
import org.tensorflow.op.core.Constant;
import org.tensorflow.op.core.Identity;
import org.tensorflow.op.core.NoOp;
import org.tensorflow.op.core.Placeholder;
import org.tensorflow.op.core.ZerosLike;
import org.tensorflow.op.train.Restore;
import org.tensorflow.op.train.Save;
import org.tensorflow.proto.framework.GraphDef;
import org.tensorflow.proto.framework.NodeDef;
import org.tensorflow.proto.util.SaverDef;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

public final class Graph
implements ExecutionEnvironment,
AutoCloseable {
    static final String INIT_OP_NAME = "Init";
    private final Object nativeHandleLock = new Object();
    private TF_Graph nativeHandle;
    private int refcount = 0;
    private SaverDef saverDef;
    private final Scope baseScope;
    private boolean dangerousGradientBuilder;
    private final Set<Operation> initializers = Collections.synchronizedSet(new LinkedHashSet());
    private int newInitializersMarker = -1;
    private static final String SAVER_DEF_SCOPE = "save";
    private static final String SAVER_DEF_FILENAME_OP = "filename";
    private static final String SAVER_DEF_SAVE_OP = "control_dependency";
    private static final String SAVER_DEF_RESTORE_OP = "restore_all";
    private static final Set<Graph> allGraphs = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public Graph() {
        this(Graph.allocate());
    }

    Graph(TF_Graph nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.baseScope = new OpScope(this);
        allGraphs.add(this);
    }

    Graph(TF_Graph nativeHandle, SaverDef saverDef) {
        this(nativeHandle);
        this.saverDef = saverDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            if (this.nativeHandle == null || this.nativeHandle.isNull()) {
                return;
            }
            while (this.refcount > 0) {
                try {
                    this.nativeHandleLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Graph.delete(this.nativeHandle);
            this.nativeHandle = null;
            allGraphs.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphOperation operation(String name) {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            TF_Operation oph = Graph.operation(this.nativeHandle, name);
            if (oph == null || oph.isNull()) {
                return null;
            }
            return new GraphOperation(this, oph);
        }
    }

    public GraphOperation operationOrThrow(String name) {
        GraphOperation op = this.operation(name);
        if (op == null) {
            throw new IllegalArgumentException("No Operation named [" + name + "] in the Graph");
        }
        return op;
    }

    public Output<?> output(String output) {
        int colon = output.lastIndexOf(58);
        if (colon == -1 || colon == output.length() - 1) {
            GraphOperation op = this.operation(output);
            if (op == null) {
                return null;
            }
            return new Output(op, 0);
        }
        try {
            String op = output.substring(0, colon);
            int index = Integer.parseInt(output.substring(colon + 1));
            GraphOperation operation = this.operation(op);
            if (operation == null) {
                return null;
            }
            return new Output(operation, index);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not get output for badly formatted output name: \"" + output + "\"", e);
        }
    }

    public Output<?> outputOrThrow(String output) {
        Output<?> op = this.output(output);
        if (op == null) {
            throw new IllegalArgumentException("No Operation named [" + output + "] in the Graph");
        }
        return op;
    }

    public Iterator<GraphOperation> operations() {
        return new OperationIterator(this);
    }

    private GraphOperation graphOp(Operand<?> operand) {
        this.checkInput(operand);
        return (GraphOperation)operand.op();
    }

    public synchronized Set<GraphOperation> completeSubgraph(Set<Operand<?>> inputs, Set<Operand<?>> outputs) {
        if (inputs == null) {
            throw new IllegalArgumentException("Inputs can't be null.");
        }
        if (outputs == null) {
            throw new IllegalArgumentException("Outputs can't be null.");
        }
        ArrayDeque<GraphOperation> currents = new ArrayDeque<GraphOperation>(outputs.size());
        LinkedHashSet<GraphOperation> seen = new LinkedHashSet<GraphOperation>(inputs.size());
        LinkedHashSet<GraphOperation> inputOps = new LinkedHashSet<GraphOperation>(inputs.size());
        for (Operand<?> input : inputs) {
            if (input.op().numOutputs() > 1) {
                throw new IllegalStateException("Only ops with one output are supported as subgraph inputs");
            }
            GraphOperation graphOperation = this.graphOp(input);
            inputOps.add(graphOperation);
            seen.add(graphOperation);
        }
        for (Operand<?> operand : outputs) {
            GraphOperation graphOperation = this.graphOp(operand);
            currents.add(graphOperation);
        }
        while (!currents.isEmpty()) {
            GraphOperation op2 = (GraphOperation)currents.poll();
            if (!seen.add(op2)) continue;
            for (GraphOperation graphOperation : op2.controlInputs()) {
                if (inputOps.contains(graphOperation)) continue;
                currents.add(graphOperation);
            }
            for (Operand operand : op2.inputs()) {
                GraphOperation inputOp = this.graphOp(operand);
                if (inputOps.contains(inputOp)) continue;
                currents.add(inputOp);
            }
        }
        return seen;
    }

    public Set<GraphOperation> subgraphToOps(Set<GraphOperation> outputs) {
        LinkedHashSet<GraphOperation> seen = new LinkedHashSet<GraphOperation>(outputs.size());
        ArrayDeque<GraphOperation> todo = new ArrayDeque<GraphOperation>(outputs);
        while (!todo.isEmpty()) {
            GraphOperation current = (GraphOperation)todo.poll();
            if (!seen.add(current)) continue;
            todo.addAll(current.inputs().stream().map(this::graphOp).collect(Collectors.toSet()));
            todo.addAll(current.controlInputs());
        }
        seen.removeAll(outputs);
        return seen;
    }

    public synchronized Set<GraphOperation> subgraphFromOps(Set<GraphOperation> inputs) {
        LinkedHashSet<GraphOperation> seen = new LinkedHashSet<GraphOperation>(inputs.size());
        ArrayDeque<GraphOperation> todo = new ArrayDeque<GraphOperation>(inputs);
        while (!todo.isEmpty()) {
            GraphOperation current = (GraphOperation)todo.poll();
            if (!seen.add(current)) continue;
            todo.addAll(current.consumers());
            todo.addAll(current.controlConsumers());
        }
        seen.removeAll(inputs);
        return seen;
    }

    public Set<GraphOperation> subgraphTo(Set<Operand<?>> outputs) {
        return this.subgraphToOps(outputs.stream().map(this::graphOp).collect(Collectors.toSet()));
    }

    public synchronized Set<GraphOperation> subgraphFrom(Set<Operand<?>> inputs) {
        LinkedHashSet<GraphOperation> ops = new LinkedHashSet<GraphOperation>();
        for (Operand<?> input : inputs) {
            GraphOperation op = this.graphOp(input);
            ops.addAll(op.consumers(input.asOutput().index()));
            ops.addAll(op.controlConsumers());
        }
        Set<GraphOperation> downstream = this.subgraphFromOps(ops);
        downstream.addAll(ops);
        return downstream;
    }

    @Override
    public GraphOperationBuilder opBuilder(String type, String name, Scope scope) {
        if (!this.isOpEnabled(type)) {
            throw new IllegalArgumentException("Op " + type + " is not valid in graph mode.");
        }
        return new GraphOperationBuilder(this, type, name, scope, this.dangerousGradientBuilder);
    }

    @Override
    public void attachFunction(ConcreteFunction function) {
        try (Reference ref = this.ref();
             PointerScope scope = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_GraphCopyFunction(ref.nativeHandle(), function.nativeHandle(), null, status);
            status.throwExceptionIfNotOK();
            function.getDependencies().forEach(x -> {
                TF_Status status2 = TF_Status.newStatus();
                tensorflow.TF_GraphCopyFunction(ref.nativeHandle(), x, null, status2);
                status2.throwExceptionIfNotOK();
            });
        }
    }

    List<NativeFunction> getNativeFunctions(PointerScope outerScope) {
        try (Reference ref = this.ref();){
            ArrayList<NativeFunction> arrayList;
            try (PointerScope scope = new PointerScope();){
                TF_Status status = TF_Status.newStatus();
                int numFunctions = tensorflow.TF_GraphNumFunctions(ref.nativeHandle());
                PointerPointer output = new PointerPointer((long)numFunctions);
                tensorflow.TF_GraphGetFunctions(ref.nativeHandle(), output, numFunctions, status);
                status.throwExceptionIfNotOK();
                ArrayList<NativeFunction> funcs = new ArrayList<NativeFunction>(numFunctions);
                for (int i = 0; i < numFunctions; ++i) {
                    TF_Function function = (TF_Function)output.get(TF_Function.class, (long)i);
                    function.withDeallocator();
                    outerScope.attach((Pointer)function);
                    funcs.add(new NativeFunction(function));
                }
                arrayList = funcs;
            }
            return arrayList;
        }
    }

    public ConcreteFunction getFunction(String key) {
        try (Reference ref = this.ref();
             PointerScope scope = new PointerScope();){
            List<NativeFunction> funcs = this.getNativeFunctions(scope);
            Iterator<NativeFunction> iterator = funcs.iterator();
            while (true) {
                if (iterator.hasNext()) {
                    NativeFunction f = iterator.next();
                    if (!f.getName().equals(key)) continue;
                    ConcreteFunction concreteFunction = ConcreteFunction.fromNativeHandle(f, funcs);
                    return concreteFunction;
                    continue;
                }
                break;
            }
        }
        return null;
    }

    public List<ConcreteFunction> getFunctions() {
        try (Reference ref = this.ref();){
            List<ConcreteFunction> list;
            try (PointerScope scope = new PointerScope();){
                List<NativeFunction> funcs = this.getNativeFunctions(scope);
                list = funcs.stream().map(x -> ConcreteFunction.fromNativeHandle(x, funcs)).collect(Collectors.toList());
            }
            return list;
        }
    }

    @Override
    public ExecutionEnvironment.Types environmentType() {
        return ExecutionEnvironment.Types.GRAPH;
    }

    @Override
    public void checkInput(Operation input) {
        if (input.env().isEager()) {
            throw new IllegalArgumentException("Input " + input + " was from an eager session, can't use in a graph.  Use tf.constantOf(input.asTensor())");
        }
        if (input.env() != this) {
            throw new IllegalArgumentException("Input " + input + " was from a different graph, can't use.");
        }
    }

    @Override
    public Scope baseScope() {
        return this.baseScope;
    }

    public void importGraphDef(GraphDef graphDef) throws IllegalArgumentException {
        this.importGraphDef(graphDef, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importGraphDef(GraphDef graphDef, String prefix) throws IllegalArgumentException {
        if (graphDef == null || prefix == null) {
            throw new IllegalArgumentException("graphDef and prefix cannot be null");
        }
        Object object = this.nativeHandleLock;
        synchronized (object) {
            Graph.importGraphDef(this.nativeHandle, graphDef, prefix);
        }
        this.baseScope.refreshNames();
        Object initPrefix = !prefix.isEmpty() ? (prefix.endsWith("/") ? prefix + INIT_OP_NAME : prefix + "/Init") : INIT_OP_NAME;
        this.operations().forEachRemaining(arg_0 -> this.lambda$importGraphDef$2((String)initPrefix, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDef toGraphDef() {
        GraphDef graphDef;
        Object object = this.nativeHandleLock;
        synchronized (object) {
            graphDef = Graph.toGraphDef(this.nativeHandle);
        }
        return this.addOrUpdateInit(graphDef);
    }

    @Override
    public boolean isInitializer(Operation op) {
        return this.initializers.contains(op);
    }

    public synchronized Output<?>[] addGradients(String prefix, Output<?>[] y, Output<?>[] x, Output<?>[] dx) {
        Output[] dy = new Output[x.length];
        TF_Operation[] yHandles = new TF_Operation[y.length];
        int[] yIndices = new int[y.length];
        TF_Operation[] xHandles = new TF_Operation[x.length];
        int[] xIndices = new int[x.length];
        TF_Operation[] dxHandles = null;
        int[] dxIndices = null;
        try (Reference ref = this.ref();){
            Object[] dyHandlesAndIndices;
            int ndy;
            int i;
            for (i = 0; i < y.length; ++i) {
                yHandles[i] = (TF_Operation)y[i].getUnsafeNativeHandle();
                yIndices[i] = y[i].index();
            }
            for (i = 0; i < x.length; ++i) {
                xHandles[i] = (TF_Operation)x[i].getUnsafeNativeHandle();
                xIndices[i] = x[i].index();
            }
            if (dx != null && dx.length > 0) {
                dxHandles = new TF_Operation[dx.length];
                dxIndices = new int[dx.length];
                for (i = 0; i < dx.length; ++i) {
                    dxHandles[i] = (TF_Operation)dx[i].getUnsafeNativeHandle();
                    dxIndices[i] = dx[i].index();
                }
            }
            if ((ndy = (dyHandlesAndIndices = Graph.addGradients(ref.nativeHandle(), prefix, yHandles, yIndices, xHandles, xIndices, dxHandles, dxIndices)).length >> 1) != dy.length) {
                throw new IllegalStateException(String.valueOf(ndy) + " gradients were added to the graph when " + dy.length + " were expected");
            }
            int i2 = 0;
            int j = ndy;
            while (i2 < ndy) {
                GraphOperation op = new GraphOperation(this, (TF_Operation)((Object)dyHandlesAndIndices[i2]));
                dy[i2] = new Output(op, (Integer)dyHandlesAndIndices[j]);
                ++i2;
                ++j;
            }
        }
        return dy;
    }

    public Output<?>[] addGradients(Output<?> y, Output<?>[] x) {
        return this.addGradients(null, new Output[]{y}, x, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] buildSubgraph(WhileSubgraphBuilder subgraphBuilder, TF_Graph subgraphHandle, TF_Operation[] inputHandles, int[] inputIndices, TF_Operation[] outputHandles, int[] outputIndices) {
        Graph subgraph = new Graph(subgraphHandle);
        int ninputs = inputHandles.length;
        int noutputs = outputHandles.length;
        Output[] inputs = new Output[ninputs];
        Output[] outputs = new Output[noutputs];
        Object[] outputHandlesAndIndices = new Object[noutputs * 2];
        Object object = subgraph.nativeHandleLock;
        synchronized (object) {
            try (Reference ref = subgraph.ref();){
                GraphOperation op;
                int i;
                for (i = 0; i < ninputs; ++i) {
                    op = new GraphOperation(subgraph, inputHandles[i]);
                    inputs[i] = op.output(inputIndices[i]);
                }
                for (i = 0; i < noutputs; ++i) {
                    op = new GraphOperation(subgraph, outputHandles[i]);
                    outputs[i] = op.output(outputIndices[i]);
                }
                subgraphBuilder.buildSubgraph(subgraph, inputs, outputs);
                i = 0;
                int j = noutputs;
                while (i < noutputs) {
                    outputHandlesAndIndices[i] = outputs[i].getUnsafeNativeHandle();
                    outputHandlesAndIndices[j] = outputs[i].index();
                    ++i;
                    ++j;
                }
            }
            return outputHandlesAndIndices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Output<?>[] whileLoop(Output<?>[] inputs, WhileSubgraphBuilder cgBuilder, WhileSubgraphBuilder bgBuilder, String name) {
        int ninputs = inputs.length;
        TF_Operation[] inputHandles = new TF_Operation[ninputs];
        int[] inputIndices = new int[ninputs];
        Output[] outputs = new Output[ninputs];
        Object object = this.nativeHandleLock;
        synchronized (object) {
            try (Reference ref = this.ref();){
                for (int i = 0; i < ninputs; ++i) {
                    inputHandles[i] = (TF_Operation)inputs[i].getUnsafeNativeHandle();
                    inputIndices[i] = inputs[i].index();
                }
                Object[] outputHandlesAndIndices = Graph.whileLoop(this.nativeHandle, inputHandles, inputIndices, name, cgBuilder, bgBuilder);
                int i = 0;
                int j = ninputs;
                while (i < ninputs) {
                    GraphOperation op = new GraphOperation(this, (TF_Operation)((Object)outputHandlesAndIndices[i]));
                    outputs[i] = op.output((Integer)outputHandlesAndIndices[j]);
                    ++i;
                    ++j;
                }
            }
            return outputs;
        }
    }

    synchronized SaverDef saverDef() {
        if (this.saverDef == null) {
            this.saverDef = this.operation("save/restore_all") == null ? Graph.addVariableSaver(this) : SaverDef.newBuilder().setFilenameTensorName("save/filename:0").setSaveTensorName("save/control_dependency").setRestoreOpName("save/restore_all").build();
        }
        return this.saverDef;
    }

    synchronized void registerInitializer(GraphOperation op, boolean isNew) {
        if (this.isInitializer(op)) {
            return;
        }
        this.checkInput(op);
        for (GraphOperation graphOperation : op.controlInputs()) {
            this.checkInput(graphOperation);
        }
        for (Operand operand : op.inputs()) {
            this.checkInput(operand.op());
        }
        if (this.initializers.add(op) && isNew && this.newInitializersMarker < 0) {
            this.newInitializersMarker = this.initializers.size() - 1;
        }
    }

    Set<Operation> initializers() {
        return this.initializers;
    }

    synchronized void setDangerousGradientBuilder(boolean dangerous) {
        this.dangerousGradientBuilder = dangerous;
    }

    Reference ref() {
        return new Reference();
    }

    private static TF_Graph allocate() {
        return tensorflow.TF_NewGraph();
    }

    private static void delete(TF_Graph handle) {
        if (handle == null || handle.isNull()) {
            return;
        }
        tensorflow.TF_DeleteGraph(handle);
    }

    private static void requireHandle(Pointer handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("close() has been called on the Graph");
        }
    }

    private static TF_Operation operation(TF_Graph handle, String name) {
        Graph.requireHandle(handle);
        return tensorflow.TF_GraphOperationByName(handle, name);
    }

    private static Object[] nextOperation(TF_Graph handle, int position) {
        Graph.requireHandle(handle);
        try (PointerScope scope = new PointerScope();){
            SizeTPointer pos = new SizeTPointer(1L).put((long)position);
            TF_Operation operation = tensorflow.TF_GraphNextOperation(handle, pos);
            if (operation == null || operation.isNull()) {
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] handleAndPosition = new Object[]{operation, (int)pos.get()};
            Object[] objectArray = handleAndPosition;
            return objectArray;
        }
    }

    private static void importGraphDef(TF_Graph handle, GraphDef graphDef, String prefix) throws IllegalArgumentException {
        Graph.requireHandle(handle);
        try (PointerScope scope = new PointerScope();){
            TF_ImportGraphDefOptions opts = TF_ImportGraphDefOptions.newImportGraphDefOptions();
            tensorflow.TF_ImportGraphDefOptionsSetPrefix(opts, prefix);
            TF_Buffer buf = TF_Buffer.newBufferFromString((Message)graphDef);
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_GraphImportGraphDef(handle, buf, opts, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static GraphDef toGraphDef(TF_Graph handle) {
        Graph.requireHandle(handle);
        try (PointerScope scope = new PointerScope();){
            TF_Buffer buf = TF_Buffer.newBuffer();
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_GraphToGraphDef(handle, buf, status);
            status.throwExceptionIfNotOK();
            try {
                GraphDef graphDef = GraphDef.parseFrom(buf.dataAsByteBuffer());
                return graphDef;
            }
            catch (InvalidProtocolBufferException e) {
                throw new TensorFlowException("Cannot parse GraphDef protocol buffer", e);
            }
        }
    }

    private GraphDef addOrUpdateInit(GraphDef graphDef) {
        if (this.newInitializersMarker < 0) {
            return graphDef;
        }
        GraphDef.Builder graphDefWithInitBuilder = graphDef.toBuilder();
        NodeDef.Builder initNode = graphDefWithInitBuilder.getNodeBuilderList().stream().filter(n -> n.getName().equals(INIT_OP_NAME)).findFirst().orElseGet(() -> graphDefWithInitBuilder.addNodeBuilder().setName(INIT_OP_NAME).setOp("NoOp"));
        this.initializers.stream().skip(this.newInitializersMarker).forEach(op -> initNode.addInput("^" + op.name()));
        return graphDefWithInitBuilder.build();
    }

    static void resolveOutputs(String type, TF_Operation[] srcOps, int[] srcIndices, TF_Output dst, int n) {
        if (srcOps.length != n) {
            throw new IllegalArgumentException("expected " + n + ", got " + srcOps.length + " " + type + " Operations");
        }
        if (srcIndices.length != n) {
            throw new IllegalArgumentException("expected " + n + ", got " + srcIndices.length + " " + type + " Operation output indices");
        }
        for (int i = 0; i < n; ++i) {
            if (srcOps[i] == null || srcOps[i].isNull()) {
                throw new IllegalStateException("invalid " + type + " (#" + i + " of " + n + ")");
            }
            dst.position(i).oper(srcOps[i]).index(srcIndices[i]);
        }
        dst.position(0L);
    }

    private static Object[] addGradients(TF_Graph handle, String prefix, TF_Operation[] inputHandles, int[] inputIndices, TF_Operation[] outputHandles, int[] outputIndices, TF_Operation[] gradInputHandles, int[] gradInputIndices) {
        Graph.requireHandle(handle);
        try (PointerScope scope = new PointerScope();){
            int ny = inputHandles.length;
            int nx = outputHandles.length;
            TF_Output y = new TF_Output(ny);
            TF_Output x = new TF_Output(nx);
            TF_Output dx = null;
            TF_Output dy = new TF_Output(nx);
            Graph.resolveOutputs("y", inputHandles, inputIndices, y, ny);
            Graph.resolveOutputs("x", outputHandles, outputIndices, x, nx);
            if (gradInputHandles != null) {
                if (gradInputHandles.length != ny) {
                    throw new IllegalArgumentException("expected " + ny + ", got " + gradInputHandles.length + " handles");
                }
                dx = new TF_Output(ny);
                Graph.resolveOutputs("dx", gradInputHandles, gradInputIndices, dx, ny);
            }
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_AddGradientsWithPrefix(handle, prefix, y, ny, x, nx, dx, status, dy);
            status.throwExceptionIfNotOK();
            Object[] gradOutputHandlesAndIndices = new Object[nx * 2];
            int i = 0;
            int j = nx;
            while (i < nx) {
                TF_Output gradOutput = dy.position(i);
                gradOutputHandlesAndIndices[i] = gradOutput.oper();
                gradOutputHandlesAndIndices[j] = gradOutput.index();
                ++i;
                ++j;
            }
            Object[] objectArray = gradOutputHandlesAndIndices;
            return objectArray;
        }
    }

    private static Object[] whileLoop(TF_Graph handle, TF_Operation[] inputHandles, int[] inputIndices, String name, WhileSubgraphBuilder condGraphBuilder, WhileSubgraphBuilder bodyGraphBuilder) {
        Graph.requireHandle(handle);
        try (PointerScope scope = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            int ninputs = inputHandles.length;
            TF_Output inputs = new TF_Output(ninputs);
            Graph.resolveOutputs("inputs", inputHandles, inputIndices, inputs, ninputs);
            TF_WhileParams params = tensorflow.TF_NewWhile(handle, inputs, ninputs, status);
            status.throwExceptionIfNotOK();
            TF_Output condInputsOutput = params.cond_inputs();
            TF_Output condOutputOutput = params.cond_output();
            TF_Operation[] condInputHandles = new TF_Operation[ninputs];
            int[] condInputIndices = new int[ninputs];
            TF_Operation[] condOutputHandles = new TF_Operation[1];
            int[] condOutputIndices = new int[1];
            for (int i = 0; i < ninputs; ++i) {
                condInputHandles[i] = condInputsOutput.position(i).oper();
                condInputIndices[i] = condInputsOutput.position(i).index();
            }
            condOutputHandles[0] = condOutputOutput.oper();
            condOutputIndices[0] = condOutputOutput.index();
            Object[] condOutputHandlesAndIndices = Graph.buildSubgraph(condGraphBuilder, params.cond_graph(), condInputHandles, condInputIndices, condOutputHandles, condOutputIndices);
            TF_Output bodyInputsOutput = params.body_inputs();
            TF_Output bodyOutputsOutput = params.body_outputs();
            TF_Operation[] bodyInputHandles = new TF_Operation[ninputs];
            int[] bodyInputIndices = new int[ninputs];
            TF_Operation[] bodyOutputHandles = new TF_Operation[ninputs];
            int[] bodyOutputIndices = new int[ninputs];
            for (int i = 0; i < ninputs; ++i) {
                bodyInputHandles[i] = bodyInputsOutput.position(i).oper();
                bodyInputIndices[i] = bodyInputsOutput.position(i).index();
                bodyOutputHandles[i] = bodyOutputsOutput.position(i).oper();
                bodyOutputIndices[i] = bodyOutputsOutput.position(i).index();
            }
            Object[] bodyOutputHandlesAndIndices = Graph.buildSubgraph(bodyGraphBuilder, params.body_graph(), bodyInputHandles, bodyInputIndices, bodyOutputHandles, bodyOutputIndices);
            if (condOutputHandlesAndIndices == null || bodyOutputHandlesAndIndices == null) {
                Object[] objectArray = null;
                return objectArray;
            }
            condOutputOutput.oper((TF_Operation)((Object)condOutputHandlesAndIndices[0])).index((Integer)condOutputHandlesAndIndices[1]);
            int i = 0;
            int j = ninputs;
            while (i < ninputs) {
                bodyOutputsOutput.position(i).oper((TF_Operation)((Object)bodyOutputHandlesAndIndices[i])).index((Integer)bodyOutputHandlesAndIndices[j]);
                ++i;
                ++j;
            }
            params.name(new BytePointer(name));
            TF_Output outputs = new TF_Output(ninputs);
            tensorflow.TF_FinishWhile(params, status, outputs);
            status.throwExceptionIfNotOK();
            Object[] outputHandlesAndIndices = new Object[ninputs * 2];
            int i2 = 0;
            int j2 = ninputs;
            while (i2 < ninputs) {
                TF_Output output = outputs.position(i2);
                outputHandlesAndIndices[i2] = output.oper();
                outputHandlesAndIndices[j2] = output.index();
                ++i2;
                ++j2;
            }
            Object[] objectArray = outputHandlesAndIndices;
            return objectArray;
        }
    }

    private static SaverDef addVariableSaver(Graph graph) {
        Ops tf = Ops.create(graph).withSubScope(SAVER_DEF_SCOPE);
        ArrayList<String> varNames = new ArrayList<String>();
        ArrayList varOutputs = new ArrayList();
        ArrayList<Class<? extends TType>> varTypes = new ArrayList<Class<? extends TType>>();
        Iterator<GraphOperation> iter = graph.operations();
        while (iter.hasNext()) {
            Operation op = iter.next();
            if (!op.type().equals("VariableV2")) continue;
            varNames.add(op.name());
            varOutputs.add(op.output(0));
            varTypes.add(op.output(0).type());
        }
        Placeholder<TString> filename = tf.withName(SAVER_DEF_FILENAME_OP).placeholder(TString.class, new Placeholder.Options[0]);
        Identity<TString> save = null;
        NoOp restore = null;
        if (varNames.isEmpty()) {
            save = tf.withName(SAVER_DEF_SAVE_OP).identity(filename);
            restore = tf.withName(SAVER_DEF_RESTORE_OP).noOp();
        } else {
            String[] tmp = new String[varNames.size()];
            Constant<TString> varNamesTensor = tf.constant(StdArrays.ndCopyOf(varNames.toArray(tmp)));
            ZerosLike<TString> varSlices = tf.zerosLike(varNamesTensor);
            Save saveVars = tf.train.save(filename, varNamesTensor, varSlices, varOutputs);
            List<Op> saveDeps = Arrays.asList(filename, saveVars);
            Restore restoreVars = tf.train.restore(filename, varNamesTensor, varSlices, varTypes);
            ArrayList<Op> restoreDeps = new ArrayList<Op>(varOutputs.size());
            for (int i = 0; i < varOutputs.size(); ++i) {
                restoreDeps.add(tf.assign((Operand)varOutputs.get(i), restoreVars.tensors().get(i), new Assign.Options[0]));
            }
            save = tf.withControlDependencies(saveDeps).withName(SAVER_DEF_SAVE_OP).identity(filename);
            restore = tf.withControlDependencies(restoreDeps).withName(SAVER_DEF_RESTORE_OP).noOp();
        }
        return SaverDef.newBuilder().setFilenameTensorName(filename.output().name()).setSaveTensorName(save.op().name()).setRestoreOpName(restore.op().name()).build();
    }

    public static Graph findGraphForPointer(NativeGraphPointer pointer) {
        for (Graph g : allGraphs) {
            if (g.nativeHandle == null || g.nativeHandle.isNull() || !g.nativeHandle.graph().equals((Object)pointer)) continue;
            return g;
        }
        return null;
    }

    private /* synthetic */ void lambda$importGraphDef$2(String initPrefix, GraphOperation op) {
        if (op.name().startsWith(initPrefix)) {
            this.registerInitializer(op, false);
        }
    }

    static {
        try {
            Class.forName("org.tensorflow.TensorFlow");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class OperationIterator
    implements Iterator<GraphOperation> {
        private final Graph graph;
        private GraphOperation operation;
        private int position;

        OperationIterator(Graph g) {
            this.graph = g;
            this.operation = null;
            this.position = 0;
            this.advance();
        }

        private final void advance() {
            this.operation = null;
            try (Reference reference = this.graph.ref();){
                Object[] nativeReturn = Graph.nextOperation(reference.nativeHandle(), this.position);
                if (nativeReturn != null && nativeReturn[0] != null && !((TF_Operation)((Object)nativeReturn[0])).isNull()) {
                    this.operation = new GraphOperation(this.graph, (TF_Operation)((Object)nativeReturn[0]));
                    this.position = (Integer)nativeReturn[1];
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.operation != null;
        }

        @Override
        public GraphOperation next() {
            GraphOperation rhett = this.operation;
            this.advance();
            return rhett;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is unsupported.");
        }
    }

    class Reference
    implements AutoCloseable {
        private boolean active;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Reference() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                boolean bl = this.active = Graph.this.nativeHandle != null && !Graph.this.nativeHandle.isNull();
                if (!this.active) {
                    throw new IllegalStateException("close() has been called on the Graph");
                }
                this.active = true;
                ++Graph.this.refcount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                if (!this.active) {
                    return;
                }
                this.active = false;
                if (--Graph.this.refcount == 0) {
                    Graph.this.nativeHandleLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TF_Graph nativeHandle() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                return this.active ? Graph.this.nativeHandle : null;
            }
        }
    }

    public static interface WhileSubgraphBuilder {
        public void buildSubgraph(Graph var1, Output<?>[] var2, Output<?>[] var3);
    }
}

