/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.audio;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;

@OpMetadata(opType="AudioSpectrogram", inputsClass=Inputs.class)
public final class AudioSpectrogram
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "AudioSpectrogram";
    private Output<TFloat32> spectrogram;

    public AudioSpectrogram(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.spectrogram = operation.output(outputIdx++);
    }

    public static AudioSpectrogram create(Scope scope, Operand<TFloat32> input, Long windowSize, Long stride, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("window_size", windowSize);
        opBuilder.setAttr("stride", stride);
        if (options != null) {
            for (Options opts : options) {
                if (opts.magnitudeSquared == null) continue;
                opBuilder.setAttr("magnitude_squared", opts.magnitudeSquared);
            }
        }
        return new AudioSpectrogram(opBuilder.build());
    }

    public static Options magnitudeSquared(Boolean magnitudeSquared) {
        return new Options().magnitudeSquared(magnitudeSquared);
    }

    public Output<TFloat32> spectrogram() {
        return this.spectrogram;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.spectrogram;
    }

    @OpInputsMetadata(outputsClass=AudioSpectrogram.class)
    public static class Inputs
    extends RawOpInputs<AudioSpectrogram> {
        public final Operand<TFloat32> input;
        public final long windowSize;
        public final long stride;
        public final boolean magnitudeSquared;

        public Inputs(GraphOperation op) {
            super(new AudioSpectrogram(op), op, Arrays.asList("window_size", "stride", "magnitude_squared"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.windowSize = op.attributes().getAttrInt("window_size");
            this.stride = op.attributes().getAttrInt("stride");
            this.magnitudeSquared = op.attributes().getAttrBool("magnitude_squared");
        }
    }

    public static class Options {
        private Boolean magnitudeSquared;

        private Options() {
        }

        public Options magnitudeSquared(Boolean magnitudeSquared) {
            this.magnitudeSquared = magnitudeSquared;
            return this;
        }
    }
}

