/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.PointerScope;
import org.bytedeco.javacpp.SizeTPointer;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Tensor;
import org.tensorflow.internal.c_api.TF_Graph;
import org.tensorflow.internal.c_api.TF_Operation;
import org.tensorflow.internal.c_api.TF_OperationDescription;
import org.tensorflow.internal.c_api.TF_Output;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.TF_Tensor;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Scope;
import org.tensorflow.proto.framework.AttrValue;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.proto.framework.NameAttrList;

public final class GraphOperationBuilder
implements OperationBuilder {
    private TF_OperationDescription unsafeNativeHandle;
    private final Graph graph;
    private final Scope scope;
    private final boolean dangerousGradientBuilder;

    GraphOperationBuilder(Graph graph, String type, String name, Scope scope, boolean dangerousGradientBuilder) {
        this.graph = graph;
        this.scope = scope;
        this.dangerousGradientBuilder = dangerousGradientBuilder;
        try (Graph.Reference r = graph.ref();){
            this.unsafeNativeHandle = dangerousGradientBuilder ? GraphOperationBuilder.allocateDangerousGradient(r.nativeHandle(), type, name) : GraphOperationBuilder.allocate(r.nativeHandle(), type, name);
        }
    }

    @Override
    public GraphOperation build() {
        this.scope.apply(this);
        try (Graph.Reference r = this.graph.ref();){
            TF_Operation built = this.dangerousGradientBuilder ? GraphOperationBuilder.finishDangerousGradient(r.nativeHandle(), this.unsafeNativeHandle) : GraphOperationBuilder.finish(this.unsafeNativeHandle);
            GraphOperation op = new GraphOperation(this.graph, built);
            this.unsafeNativeHandle = null;
            this.scope.onOpCreated(op);
            GraphOperation graphOperation = op;
            return graphOperation;
        }
    }

    @Override
    public GraphOperationBuilder addControlInput(Operation control) {
        this.graph.checkInput(control);
        if (control.env() != this.graph) {
            throw new IllegalArgumentException("Control input " + control + " was from a different graph, can't use.");
        }
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.addControlInput(this.unsafeNativeHandle, ((GraphOperation)control).getUnsafeNativeHandle());
        }
        return this;
    }

    @Override
    public GraphOperationBuilder addInput(Output<?> input) {
        this.graph.checkInput(input);
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.addInput(this.unsafeNativeHandle, (TF_Operation)input.getUnsafeNativeHandle(), input.index());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder addInputList(Output<?>[] inputs) {
        for (Output<?> input : inputs) {
            this.graph.checkInput(input);
        }
        try (Graph.Reference r = this.graph.ref();){
            TF_Operation[] opHandles = new TF_Operation[inputs.length];
            int[] indices = new int[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                opHandles[i] = (TF_Operation)inputs[i].getUnsafeNativeHandle();
                indices[i] = inputs[i].index();
            }
            GraphOperationBuilder.addInputList(this.unsafeNativeHandle, opHandles, indices);
        }
        return this;
    }

    @Override
    public GraphOperationBuilder setDevice(String device) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setDevice(this.unsafeNativeHandle, device);
        }
        return this;
    }

    @Override
    public GraphOperationBuilder setAttr(String name, String value) {
        this.setAttr(name, value.getBytes(Charset.forName("UTF-8")));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, byte[] value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrString(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, long value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrInt(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, long[] value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrIntList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, float value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrFloat(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, float[] value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrFloatList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, boolean value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrBool(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, boolean[] value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrBoolList(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, DataType value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrType(this.unsafeNativeHandle, name, value.getNumber());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, DataType[] value) {
        int[] ctypes = new int[value.length];
        for (int i = 0; i < value.length; ++i) {
            ctypes[i] = value[i].getNumber();
        }
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrTypeList(this.unsafeNativeHandle, name, ctypes);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, Tensor value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrTensor(this.unsafeNativeHandle, name, value.asRawTensor().nativeHandle());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, Tensor[] value) {
        TF_Tensor[] handles = new TF_Tensor[value.length];
        int idx = 0;
        for (Tensor t : value) {
            handles[idx++] = t.asRawTensor().nativeHandle();
        }
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrTensorList(this.unsafeNativeHandle, name, handles);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, Shape value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrShape(this.unsafeNativeHandle, name, value.asArray(), value.numDimensions());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, Shape[] value) {
        int[] numDimensions = new int[value.length];
        int totalNumDimensions = 0;
        for (int idx = 0; idx < value.length; ++idx) {
            int n;
            numDimensions[idx] = n = value[idx].numDimensions();
            if (n <= 0) continue;
            totalNumDimensions += n;
        }
        long[] shapes = new long[totalNumDimensions];
        int shapeIdx = 0;
        for (Shape shape : value) {
            if (shape.numDimensions() <= 0) continue;
            for (long dim : shape.asArray()) {
                shapes[shapeIdx++] = dim;
            }
        }
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrShapeList(this.unsafeNativeHandle, name, shapes, numDimensions);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GraphOperationBuilder setAttr(String name, String[] value) {
        Charset utf8 = Charset.forName("UTF-8");
        byte[][] objects = new byte[value.length][];
        for (int i = 0; i < value.length; ++i) {
            objects[i] = value[i].getBytes(utf8);
        }
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrStringList(this.unsafeNativeHandle, name, objects);
        }
        return this;
    }

    @Override
    public OperationBuilder setAttr(String name, ConcreteFunction value) {
        this.graph.attachFunction(value);
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrFunctionName(this.unsafeNativeHandle, name, value.getDefinedName());
        }
        return this;
    }

    @Override
    public OperationBuilder setAttr(String name, ConcreteFunction[] value) {
        for (ConcreteFunction f : value) {
            this.graph.attachFunction(f);
        }
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrFunctionList(this.unsafeNativeHandle, name, Arrays.stream(value).map(ConcreteFunction::getDefinedName).collect(Collectors.toList()));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationBuilder setAttr(String name, AttrValue value) {
        try (Graph.Reference r = this.graph.ref();){
            GraphOperationBuilder.setAttrValue(this.unsafeNativeHandle, name, value);
        }
        return this;
    }

    private static void requireHandle(Pointer handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("Operation has already been built");
        }
    }

    private static void resolveOutput(TF_Operation opHandle, int index, TF_Output out) {
        if (opHandle == null || opHandle.isNull()) {
            throw new IllegalStateException("close() was called on the Graph");
        }
        out.oper(opHandle);
        out.index(index);
    }

    private static void requireTensor(TF_Tensor handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("close() has been called on the Tensor");
        }
    }

    private static TF_OperationDescription allocate(TF_Graph graphHandle, String type, String name) {
        if (graphHandle == null || graphHandle.isNull()) {
            throw new IllegalStateException("close() has been called on the Graph");
        }
        return tensorflow.TF_NewOperation(graphHandle, type, name);
    }

    private static TF_OperationDescription allocateDangerousGradient(TF_Graph graphHandle, String type, String name) {
        if (graphHandle == null || graphHandle.isNull()) {
            throw new IllegalStateException("close() has been called on the Graph");
        }
        return tensorflow.TF_NewOperationLocked(graphHandle, type, name);
    }

    private static TF_Operation finish(TF_OperationDescription handle) {
        GraphOperationBuilder.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            TF_Operation op = tensorflow.TF_FinishOperation(handle, status);
            status.throwExceptionIfNotOK();
            TF_Operation tF_Operation = op;
            return tF_Operation;
        }
    }

    private static TF_Operation finishDangerousGradient(TF_Graph g, TF_OperationDescription handle) {
        GraphOperationBuilder.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            TF_Operation op = tensorflow.TF_FinishOperationLocked(handle, status);
            status.throwExceptionIfNotOK();
            g.name_map().erase(tensorflow.TF_OperationName(op));
            TF_Operation tF_Operation = op;
            return tF_Operation;
        }
    }

    private static void addInput(TF_OperationDescription handle, TF_Operation opHandle, int index) {
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Output out = new TF_Output();
            GraphOperationBuilder.resolveOutput(opHandle, index, out);
            GraphOperationBuilder.requireHandle(handle);
            tensorflow.TF_AddInput(handle, out);
        }
    }

    private static void addInputList(TF_OperationDescription handle, TF_Operation[] opHandles, int[] indices) {
        GraphOperationBuilder.requireHandle(handle);
        if (indices.length != opHandles.length) {
            throw new IllegalArgumentException("mismatch in number of Operations (" + opHandles.length + ") and output indices (" + indices.length + ") provided");
        }
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Output o = new TF_Output(indices.length);
            for (int i = 0; i < indices.length; ++i) {
                GraphOperationBuilder.resolveOutput(opHandles[i], indices[i], o.position(i));
            }
            tensorflow.TF_AddInputList(handle, o.position(0L), indices.length);
        }
    }

    private static void addControlInput(TF_OperationDescription handle, TF_Operation opHandle) {
        if (opHandle == null || opHandle.isNull()) {
            throw new IllegalStateException("control input is not valid, perhaps the Graph containing it has been closed()?");
        }
        GraphOperationBuilder.requireHandle(handle);
        tensorflow.TF_AddControlInput(handle, opHandle);
    }

    private static void setDevice(TF_OperationDescription handle, String device) {
        GraphOperationBuilder.requireHandle(handle);
        tensorflow.TF_SetDevice(handle, device);
    }

    private static void setAttrString(TF_OperationDescription handle, String name, byte[] value) {
        GraphOperationBuilder.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            tensorflow.TF_SetAttrString(handle, name, (Pointer)new BytePointer(value), (long)value.length);
        }
    }

    private static void setAttrInt(TF_OperationDescription handle, String name, long value) {
        GraphOperationBuilder.requireHandle(handle);
        tensorflow.TF_SetAttrInt(handle, name, value);
    }

    private static void setAttrIntList(TF_OperationDescription handle, String name, long[] value) {
        GraphOperationBuilder.requireHandle(handle);
        tensorflow.TF_SetAttrIntList(handle, name, value, value.length);
    }

    private static void setAttrFloat(TF_OperationDescription handle, String name, float value) {
        GraphOperationBuilder.requireHandle(handle);
        tensorflow.TF_SetAttrFloat(handle, name, value);
    }

    private static void setAttrFloatList(TF_OperationDescription handle, String name, float[] value) {
        GraphOperationBuilder.requireHandle(handle);
        tensorflow.TF_SetAttrFloatList(handle, name, value, value.length);
    }

    private static void setAttrBool(TF_OperationDescription handle, String name, boolean value) {
        GraphOperationBuilder.requireHandle(handle);
        tensorflow.TF_SetAttrBool(handle, name, (byte)(value ? 1 : 0));
    }

    private static void setAttrBoolList(TF_OperationDescription handle, String name, boolean[] value) {
        GraphOperationBuilder.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            tensorflow.TF_SetAttrBoolList(handle, name, new BytePointer((Pointer)new BooleanPointer(value)), value.length);
        }
    }

    private static void setAttrType(TF_OperationDescription handle, String name, int type) {
        GraphOperationBuilder.requireHandle(handle);
        tensorflow.TF_SetAttrType(handle, name, type);
    }

    private static void setAttrTypeList(TF_OperationDescription handle, String name, int[] type) {
        GraphOperationBuilder.requireHandle(handle);
        tensorflow.TF_SetAttrTypeList(handle, name, type, type.length);
    }

    private static void setAttrTensor(TF_OperationDescription handle, String name, TF_Tensor tensorHandle) {
        GraphOperationBuilder.requireHandle(handle);
        GraphOperationBuilder.requireTensor(tensorHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_SetAttrTensor(handle, name, tensorHandle, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static void setAttrTensorList(TF_OperationDescription handle, String name, TF_Tensor[] tensorHandles) {
        GraphOperationBuilder.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            PointerPointer tensors = new PointerPointer((long)tensorHandles.length);
            for (int i = 0; i < tensorHandles.length; ++i) {
                GraphOperationBuilder.requireTensor(tensorHandles[i]);
                tensors.put((long)i, (Pointer)tensorHandles[i]);
            }
            TF_Status status = TF_Status.newStatus();
            tensorflow.TF_SetAttrTensorList(handle, new BytePointer(name), tensors.position(0L), tensorHandles.length, status);
            status.throwExceptionIfNotOK();
        }
    }

    private static void setAttrShape(TF_OperationDescription handle, String name, long[] shape, int numDims) {
        GraphOperationBuilder.requireHandle(handle);
        tensorflow.TF_SetAttrShape(handle, name, shape, numDims);
    }

    private static void setAttrShapeList(TF_OperationDescription handle, String name, long[] shapes, int[] numDims) {
        GraphOperationBuilder.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            LongPointer shapesPointer = new LongPointer(shapes);
            PointerPointer shapesPointers = new PointerPointer((long)numDims.length);
            for (int i = 0; i < numDims.length; ++i) {
                shapesPointers.put((long)i, (Pointer)shapesPointer);
                shapesPointer.position(shapesPointer.position() + (long)(numDims[i] * 8));
            }
            tensorflow.TF_SetAttrShapeList(handle, new BytePointer(name), shapesPointers, new IntPointer(numDims), numDims.length);
        }
    }

    private static void setAttrStringList(TF_OperationDescription handle, String name, byte[][] value) {
        GraphOperationBuilder.requireHandle(handle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            PointerPointer valuePointers = new PointerPointer((long)value.length);
            SizeTPointer lengths = new SizeTPointer((long)value.length);
            for (int i = 0; i < value.length; ++i) {
                valuePointers.put((long)i, (Pointer)new BytePointer(value[i]));
                lengths.put((long)i, (long)value[i].length);
            }
            tensorflow.TF_SetAttrStringList(handle, new BytePointer(name), valuePointers, lengths, value.length);
        }
    }

    private static void setAttrFunctionName(TF_OperationDescription opHandle, String attrName, String functionName) {
        GraphOperationBuilder.requireHandle(opHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            tensorflow.TF_SetAttrFuncName(opHandle, attrName, functionName, (long)functionName.length());
        }
    }

    private static void setAttrFunctionList(TF_OperationDescription opHandle, String attrName, List<String> functionNames) {
        AttrValue value = AttrValue.newBuilder().setList(AttrValue.ListValue.newBuilder().addAllFunc(functionNames.stream().map(x -> NameAttrList.newBuilder().setName((String)x).build()).collect(Collectors.toList())).build()).build();
        GraphOperationBuilder.setAttrValue(opHandle, attrName, value);
    }

    private static void setAttrValue(TF_OperationDescription opHandle, String attrName, AttrValue value) {
        GraphOperationBuilder.requireHandle(opHandle);
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            byte[] bytes = value.toByteArray();
            tensorflow.TF_SetAttrValueProto(opHandle, attrName, (Pointer)new BytePointer(bytes), (long)bytes.length, status);
            status.throwExceptionIfNotOK();
        }
    }
}

