/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="QuantizedBiasAdd", inputsClass=Inputs.class)
public final class QuantizedBiasAdd<V extends TNumber>
extends RawOp {
    public static final String OP_NAME = "QuantizedBiasAdd";
    private Output<V> output;
    private Output<TFloat32> minOut;
    private Output<TFloat32> maxOut;

    public QuantizedBiasAdd(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.minOut = operation.output(outputIdx++);
        this.maxOut = operation.output(outputIdx++);
    }

    public static <V extends TNumber> QuantizedBiasAdd<V> create(Scope scope, Operand<? extends TNumber> input, Operand<? extends TNumber> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minBias, Operand<TFloat32> maxBias, Class<V> outType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(bias.asOutput());
        opBuilder.addInput(minInput.asOutput());
        opBuilder.addInput(maxInput.asOutput());
        opBuilder.addInput(minBias.asOutput());
        opBuilder.addInput(maxBias.asOutput());
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        return new QuantizedBiasAdd<V>(opBuilder.build());
    }

    public Output<V> output() {
        return this.output;
    }

    public Output<TFloat32> minOut() {
        return this.minOut;
    }

    public Output<TFloat32> maxOut() {
        return this.maxOut;
    }

    @OpInputsMetadata(outputsClass=QuantizedBiasAdd.class)
    public static class Inputs
    extends RawOpInputs<QuantizedBiasAdd<?>> {
        public final Operand<? extends TNumber> input;
        public final Operand<? extends TNumber> bias;
        public final Operand<TFloat32> minInput;
        public final Operand<TFloat32> maxInput;
        public final Operand<TFloat32> minBias;
        public final Operand<TFloat32> maxBias;
        public final DataType T1;
        public final DataType T2;
        public final DataType outType;

        public Inputs(GraphOperation op) {
            super(new QuantizedBiasAdd(op), op, Arrays.asList("T1", "T2", "out_type"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.bias = op.input(inputIndex++);
            this.minInput = op.input(inputIndex++);
            this.maxInput = op.input(inputIndex++);
            this.minBias = op.input(inputIndex++);
            this.maxBias = op.input(inputIndex++);
            this.T1 = op.attributes().getAttrType("T1");
            this.T2 = op.attributes().getAttrType("T2");
            this.outType = op.attributes().getAttrType("out_type");
        }
    }
}

