/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.image.AdjustContrast;
import org.tensorflow.op.image.AdjustHue;
import org.tensorflow.op.image.AdjustSaturation;
import org.tensorflow.op.image.CombinedNonMaxSuppression;
import org.tensorflow.op.image.CropAndResize;
import org.tensorflow.op.image.CropAndResizeGradBoxes;
import org.tensorflow.op.image.CropAndResizeGradImage;
import org.tensorflow.op.image.DecodeAndCropJpeg;
import org.tensorflow.op.image.DecodeBmp;
import org.tensorflow.op.image.DecodeGif;
import org.tensorflow.op.image.DecodeImage;
import org.tensorflow.op.image.DecodeJpeg;
import org.tensorflow.op.image.DecodePng;
import org.tensorflow.op.image.DrawBoundingBoxes;
import org.tensorflow.op.image.EncodeJpeg;
import org.tensorflow.op.image.EncodeJpegVariableQuality;
import org.tensorflow.op.image.EncodePng;
import org.tensorflow.op.image.ExtractImagePatches;
import org.tensorflow.op.image.ExtractJpegShape;
import org.tensorflow.op.image.HsvToRgb;
import org.tensorflow.op.image.NonMaxSuppression;
import org.tensorflow.op.image.NonMaxSuppressionWithOverlaps;
import org.tensorflow.op.image.QuantizedResizeBilinear;
import org.tensorflow.op.image.RandomCrop;
import org.tensorflow.op.image.ResizeArea;
import org.tensorflow.op.image.ResizeBicubic;
import org.tensorflow.op.image.ResizeBilinear;
import org.tensorflow.op.image.ResizeNearestNeighbor;
import org.tensorflow.op.image.RgbToHsv;
import org.tensorflow.op.image.SampleDistortedBoundingBox;
import org.tensorflow.op.image.ScaleAndTranslate;
import org.tensorflow.op.image.StatelessSampleDistortedBoundingBox;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.TUint8;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class ImageOps {
    private final Scope scope;
    private final Ops ops;

    ImageOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public <T extends TNumber> AdjustContrast<T> adjustContrast(Operand<T> images, Operand<TFloat32> contrastFactor) {
        return AdjustContrast.create(this.scope, images, contrastFactor);
    }

    public <T extends TNumber> AdjustHue<T> adjustHue(Operand<T> images, Operand<TFloat32> delta) {
        return AdjustHue.create(this.scope, images, delta);
    }

    public <T extends TNumber> AdjustSaturation<T> adjustSaturation(Operand<T> images, Operand<TFloat32> scale) {
        return AdjustSaturation.create(this.scope, images, scale);
    }

    public CombinedNonMaxSuppression combinedNonMaxSuppression(Operand<TFloat32> boxes, Operand<TFloat32> scores, Operand<TInt32> maxOutputSizePerClass, Operand<TInt32> maxTotalSize, Operand<TFloat32> iouThreshold, Operand<TFloat32> scoreThreshold, CombinedNonMaxSuppression.Options ... options) {
        return CombinedNonMaxSuppression.create(this.scope, boxes, scores, maxOutputSizePerClass, maxTotalSize, iouThreshold, scoreThreshold, options);
    }

    public CropAndResize cropAndResize(Operand<? extends TNumber> image, Operand<TFloat32> boxes, Operand<TInt32> boxInd, Operand<TInt32> cropSize, CropAndResize.Options ... options) {
        return CropAndResize.create(this.scope, image, boxes, boxInd, cropSize, options);
    }

    public CropAndResizeGradBoxes cropAndResizeGradBoxes(Operand<TFloat32> grads, Operand<? extends TNumber> image, Operand<TFloat32> boxes, Operand<TInt32> boxInd, CropAndResizeGradBoxes.Options ... options) {
        return CropAndResizeGradBoxes.create(this.scope, grads, image, boxes, boxInd, options);
    }

    public <T extends TNumber> CropAndResizeGradImage<T> cropAndResizeGradImage(Operand<TFloat32> grads, Operand<TFloat32> boxes, Operand<TInt32> boxInd, Operand<TInt32> imageSize, Class<T> T, CropAndResizeGradImage.Options ... options) {
        return CropAndResizeGradImage.create(this.scope, grads, boxes, boxInd, imageSize, T, options);
    }

    public DecodeAndCropJpeg decodeAndCropJpeg(Operand<TString> contents, Operand<TInt32> cropWindow, DecodeAndCropJpeg.Options ... options) {
        return DecodeAndCropJpeg.create(this.scope, contents, cropWindow, options);
    }

    public DecodeBmp decodeBmp(Operand<TString> contents, DecodeBmp.Options ... options) {
        return DecodeBmp.create(this.scope, contents, options);
    }

    public DecodeGif decodeGif(Operand<TString> contents) {
        return DecodeGif.create(this.scope, contents);
    }

    public DecodeImage<TUint8> decodeImage(Operand<TString> contents, DecodeImage.Options[] options) {
        return DecodeImage.create(this.scope, contents, options);
    }

    public <T extends TNumber> DecodeImage<T> decodeImage(Operand<TString> contents, Class<T> dtype, DecodeImage.Options ... options) {
        return DecodeImage.create(this.scope, contents, dtype, options);
    }

    public DecodeJpeg decodeJpeg(Operand<TString> contents, DecodeJpeg.Options ... options) {
        return DecodeJpeg.create(this.scope, contents, options);
    }

    public DecodePng<TUint8> decodePng(Operand<TString> contents, DecodePng.Options[] options) {
        return DecodePng.create(this.scope, contents, options);
    }

    public <T extends TNumber> DecodePng<T> decodePng(Operand<TString> contents, Class<T> dtype, DecodePng.Options ... options) {
        return DecodePng.create(this.scope, contents, dtype, options);
    }

    public <T extends TNumber> DrawBoundingBoxes<T> drawBoundingBoxes(Operand<T> images, Operand<TFloat32> boxes, Operand<TFloat32> colors) {
        return DrawBoundingBoxes.create(this.scope, images, boxes, colors);
    }

    public EncodeJpeg encodeJpeg(Operand<TUint8> image, EncodeJpeg.Options ... options) {
        return EncodeJpeg.create(this.scope, image, options);
    }

    public EncodeJpegVariableQuality encodeJpegVariableQuality(Operand<TUint8> images, Operand<TInt32> quality) {
        return EncodeJpegVariableQuality.create(this.scope, images, quality);
    }

    public EncodePng encodePng(Operand<? extends TNumber> image, EncodePng.Options ... options) {
        return EncodePng.create(this.scope, image, options);
    }

    public <T extends TType> ExtractImagePatches<T> extractImagePatches(Operand<T> images, List<Long> ksizes, List<Long> strides, List<Long> rates, String padding) {
        return ExtractImagePatches.create(this.scope, images, ksizes, strides, rates, padding);
    }

    public ExtractJpegShape<TInt32> extractJpegShape(Operand<TString> contents) {
        return ExtractJpegShape.create(this.scope, contents);
    }

    public <T extends TNumber> ExtractJpegShape<T> extractJpegShape(Operand<TString> contents, Class<T> outputType) {
        return ExtractJpegShape.create(this.scope, contents, outputType);
    }

    public <T extends TNumber> HsvToRgb<T> hsvToRgb(Operand<T> images) {
        return HsvToRgb.create(this.scope, images);
    }

    public <T extends TNumber> NonMaxSuppression<T> nonMaxSuppression(Operand<T> boxes, Operand<T> scores, Operand<TInt32> maxOutputSize, Operand<T> iouThreshold, Operand<T> scoreThreshold, Operand<T> softNmsSigma, NonMaxSuppression.Options ... options) {
        return NonMaxSuppression.create(this.scope, boxes, scores, maxOutputSize, iouThreshold, scoreThreshold, softNmsSigma, options);
    }

    public NonMaxSuppressionWithOverlaps nonMaxSuppressionWithOverlaps(Operand<TFloat32> overlaps, Operand<TFloat32> scores, Operand<TInt32> maxOutputSize, Operand<TFloat32> overlapThreshold, Operand<TFloat32> scoreThreshold) {
        return NonMaxSuppressionWithOverlaps.create(this.scope, overlaps, scores, maxOutputSize, overlapThreshold, scoreThreshold);
    }

    public <T extends TNumber> QuantizedResizeBilinear<T> quantizedResizeBilinear(Operand<T> images, Operand<TInt32> sizeOutput, Operand<TFloat32> min, Operand<TFloat32> max, QuantizedResizeBilinear.Options ... options) {
        return QuantizedResizeBilinear.create(this.scope, images, sizeOutput, min, max, options);
    }

    public <T extends TNumber> RandomCrop<T> randomCrop(Operand<T> image, Operand<TInt64> sizeOutput, RandomCrop.Options ... options) {
        return RandomCrop.create(this.scope, image, sizeOutput, options);
    }

    public ResizeArea resizeArea(Operand<? extends TNumber> images, Operand<TInt32> sizeOutput, ResizeArea.Options ... options) {
        return ResizeArea.create(this.scope, images, sizeOutput, options);
    }

    public ResizeBicubic resizeBicubic(Operand<? extends TNumber> images, Operand<TInt32> sizeOutput, ResizeBicubic.Options ... options) {
        return ResizeBicubic.create(this.scope, images, sizeOutput, options);
    }

    public ResizeBilinear resizeBilinear(Operand<? extends TNumber> images, Operand<TInt32> sizeOutput, ResizeBilinear.Options ... options) {
        return ResizeBilinear.create(this.scope, images, sizeOutput, options);
    }

    public <T extends TNumber> ResizeNearestNeighbor<T> resizeNearestNeighbor(Operand<T> images, Operand<TInt32> sizeOutput, ResizeNearestNeighbor.Options ... options) {
        return ResizeNearestNeighbor.create(this.scope, images, sizeOutput, options);
    }

    public <T extends TNumber> RgbToHsv<T> rgbToHsv(Operand<T> images) {
        return RgbToHsv.create(this.scope, images);
    }

    public <T extends TNumber> SampleDistortedBoundingBox<T> sampleDistortedBoundingBox(Operand<T> imageSize, Operand<TFloat32> boundingBoxes, Operand<TFloat32> minObjectCovered, SampleDistortedBoundingBox.Options ... options) {
        return SampleDistortedBoundingBox.create(this.scope, imageSize, boundingBoxes, minObjectCovered, options);
    }

    public ScaleAndTranslate scaleAndTranslate(Operand<? extends TNumber> images, Operand<TInt32> sizeOutput, Operand<TFloat32> scale, Operand<TFloat32> translation, ScaleAndTranslate.Options ... options) {
        return ScaleAndTranslate.create(this.scope, images, sizeOutput, scale, translation, options);
    }

    public <T extends TNumber> StatelessSampleDistortedBoundingBox<T> statelessSampleDistortedBoundingBox(Operand<T> imageSize, Operand<TFloat32> boundingBoxes, Operand<TFloat32> minObjectCovered, Operand<? extends TNumber> seed, StatelessSampleDistortedBoundingBox.Options ... options) {
        return StatelessSampleDistortedBoundingBox.create(this.scope, imageSize, boundingBoxes, minObjectCovered, seed, options);
    }

    public final Ops ops() {
        return this.ops;
    }
}

