/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.Tensor;
import org.tensorflow.internal.types.TInt32Mapper;
import org.tensorflow.ndarray.IntNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.annotation.TensorType;
import org.tensorflow.types.family.TIntegral;

@TensorType(dataType=DataType.DT_INT32, byteSize=4, mapperClass=TInt32Mapper.class)
public interface TInt32
extends IntNdArray,
TIntegral {
    public static TInt32 scalarOf(int value) {
        return Tensor.of(TInt32.class, Shape.scalar(), (T data) -> data.setInt(value, new long[0]));
    }

    public static TInt32 vectorOf(int ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(TInt32.class, Shape.of(values.length), (T data) -> StdArrays.copyTo(values, (IntNdArray)data));
    }

    public static TInt32 tensorOf(NdArray<Integer> src) {
        return Tensor.of(TInt32.class, src.shape(), src::copyTo);
    }

    public static TInt32 tensorOf(Shape shape) {
        return Tensor.of(TInt32.class, shape);
    }

    public static TInt32 tensorOf(Shape shape, IntDataBuffer data) {
        return Tensor.of(TInt32.class, shape, (T d) -> d.write(data));
    }

    public static TInt32 tensorOf(Shape shape, Consumer<TInt32> dataInit) {
        return Tensor.of(TInt32.class, shape, dataInit);
    }
}

