/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="EditDistance", inputsClass=Inputs.class)
public final class EditDistance
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "EditDistance";
    private Output<TFloat32> output;

    public EditDistance(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> EditDistance create(Scope scope, Operand<TInt64> hypothesisIndices, Operand<T> hypothesisValues, Operand<TInt64> hypothesisShape, Operand<TInt64> truthIndices, Operand<T> truthValues, Operand<TInt64> truthShape, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(hypothesisIndices.asOutput());
        opBuilder.addInput(hypothesisValues.asOutput());
        opBuilder.addInput(hypothesisShape.asOutput());
        opBuilder.addInput(truthIndices.asOutput());
        opBuilder.addInput(truthValues.asOutput());
        opBuilder.addInput(truthShape.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.normalize == null) continue;
                opBuilder.setAttr("normalize", opts.normalize);
            }
        }
        return new EditDistance(opBuilder.build());
    }

    public static Options normalize(Boolean normalize) {
        return new Options().normalize(normalize);
    }

    public Output<TFloat32> output() {
        return this.output;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=EditDistance.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<EditDistance> {
        public final Operand<TInt64> hypothesisIndices;
        public final Operand<T> hypothesisValues;
        public final Operand<TInt64> hypothesisShape;
        public final Operand<TInt64> truthIndices;
        public final Operand<T> truthValues;
        public final Operand<TInt64> truthShape;
        public final boolean normalize;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new EditDistance(op), op, Arrays.asList("normalize", "T"));
            int inputIndex = 0;
            this.hypothesisIndices = op.input(inputIndex++);
            this.hypothesisValues = op.input(inputIndex++);
            this.hypothesisShape = op.input(inputIndex++);
            this.truthIndices = op.input(inputIndex++);
            this.truthValues = op.input(inputIndex++);
            this.truthShape = op.input(inputIndex++);
            this.normalize = op.attributes().getAttrBool("normalize");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean normalize;

        private Options() {
        }

        public Options normalize(Boolean normalize) {
            this.normalize = normalize;
            return this;
        }
    }
}

