/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ChooseFastestBranchDataset", inputsClass=Inputs.class)
public final class ChooseFastestBranchDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ChooseFastestBranchDataset";
    private Output<? extends TType> handle;

    public ChooseFastestBranchDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static ChooseFastestBranchDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TInt64> ratioNumerator, Operand<TInt64> ratioDenominator, Iterable<Operand<?>> otherArguments, Long numElementsPerBranch, List<ConcreteFunction> branches, List<Long> otherArgumentsLengths, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(ratioNumerator.asOutput());
        opBuilder.addInput(ratioDenominator.asOutput());
        opBuilder.addInputList(Operands.asOutputs(otherArguments));
        opBuilder.setAttr("num_elements_per_branch", numElementsPerBranch);
        ConcreteFunction[] branchesArray = new ConcreteFunction[branches.size()];
        for (int i = 0; i < branchesArray.length; ++i) {
            branchesArray[i] = branches.get(i);
        }
        opBuilder.setAttr("branches", branchesArray);
        long[] otherArgumentsLengthsArray = new long[otherArgumentsLengths.size()];
        for (int i = 0; i < otherArgumentsLengthsArray.length; ++i) {
            otherArgumentsLengthsArray[i] = otherArgumentsLengths.get(i);
        }
        opBuilder.setAttr("other_arguments_lengths", otherArgumentsLengthsArray);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new ChooseFastestBranchDataset(opBuilder.build());
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=ChooseFastestBranchDataset.class)
    public static class Inputs
    extends RawOpInputs<ChooseFastestBranchDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TInt64> ratioNumerator;
        public final Operand<TInt64> ratioDenominator;
        public final Iterable<Operand<?>> otherArguments;
        public final DataType[] Targuments;
        public final long numElementsPerBranch;
        public final long[] otherArgumentsLengths;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new ChooseFastestBranchDataset(op), op, Arrays.asList("Targuments", "num_elements_per_branch", "other_arguments_lengths", "output_types", "output_shapes"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.ratioNumerator = op.input(inputIndex++);
            this.ratioDenominator = op.input(inputIndex++);
            int otherArgumentsLength = op.inputListLength("other_arguments");
            this.otherArguments = Arrays.asList((Operand[])op.inputList(inputIndex, otherArgumentsLength));
            inputIndex += otherArgumentsLength;
            this.Targuments = op.attributes().getAttrTypeList("Targuments");
            this.numElementsPerBranch = op.attributes().getAttrInt("num_elements_per_branch");
            this.otherArgumentsLengths = op.attributes().getAttrIntList("other_arguments_lengths");
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }
}

