/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class TakeManySparseFromTensorsMap<T extends TType>
extends RawOp {
    public static final String OP_NAME = "TakeManySparseFromTensorsMap";
    private Output<TInt64> sparseIndices;
    private Output<T> sparseValues;
    private Output<TInt64> sparseShape;

    public static <T extends TType> TakeManySparseFromTensorsMap<T> create(Scope scope, Operand<TInt64> sparseHandles, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(sparseHandles.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new TakeManySparseFromTensorsMap<T>(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<TInt64> sparseIndices() {
        return this.sparseIndices;
    }

    public Output<T> sparseValues() {
        return this.sparseValues;
    }

    public Output<TInt64> sparseShape() {
        return this.sparseShape;
    }

    private TakeManySparseFromTensorsMap(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.sparseIndices = operation.output(outputIdx++);
        this.sparseValues = operation.output(outputIdx++);
        this.sparseShape = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

