/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

public final class GenerateBoundingBoxProposals
extends RawOp {
    public static final String OP_NAME = "GenerateBoundingBoxProposals";
    private Output<TFloat32> rois;
    private Output<TFloat32> roiProbabilities;

    public static GenerateBoundingBoxProposals create(Scope scope, Operand<TFloat32> scores, Operand<TFloat32> bboxDeltas, Operand<TFloat32> imageInfo, Operand<TFloat32> anchors, Operand<TFloat32> nmsThreshold, Operand<TInt32> preNmsTopn, Operand<TFloat32> minSize, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(scores.asOutput());
        opBuilder.addInput(bboxDeltas.asOutput());
        opBuilder.addInput(imageInfo.asOutput());
        opBuilder.addInput(anchors.asOutput());
        opBuilder.addInput(nmsThreshold.asOutput());
        opBuilder.addInput(preNmsTopn.asOutput());
        opBuilder.addInput(minSize.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.postNmsTopn == null) continue;
                opBuilder.setAttr("post_nms_topn", opts.postNmsTopn);
            }
        }
        return new GenerateBoundingBoxProposals(opBuilder.build());
    }

    public static Options postNmsTopn(Long postNmsTopn) {
        return new Options().postNmsTopn(postNmsTopn);
    }

    public Output<TFloat32> rois() {
        return this.rois;
    }

    public Output<TFloat32> roiProbabilities() {
        return this.roiProbabilities;
    }

    private GenerateBoundingBoxProposals(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.rois = operation.output(outputIdx++);
        this.roiProbabilities = operation.output(outputIdx++);
    }

    public static class Options {
        private Long postNmsTopn;

        public Options postNmsTopn(Long postNmsTopn) {
            this.postNmsTopn = postNmsTopn;
            return this;
        }

        private Options() {
        }
    }
}

