/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

public final class OptimizeDatasetV2
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "OptimizeDatasetV2";
    private Output<?> handle;

    public static OptimizeDatasetV2 create(Scope scope, Operand<?> inputDataset, Operand<TString> optimizationsEnabled, Operand<TString> optimizationsDisabled, Operand<TString> optimizationsDefault, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(optimizationsEnabled.asOutput());
        opBuilder.addInput(optimizationsDisabled.asOutput());
        opBuilder.addInput(optimizationsDefault.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.optimizationConfigs == null) continue;
                String[] optimizationConfigsArray = new String[opts.optimizationConfigs.size()];
                for (int i = 0; i < optimizationConfigsArray.length; ++i) {
                    optimizationConfigsArray[i] = (String)opts.optimizationConfigs.get(i);
                }
                opBuilder.setAttr("optimization_configs", optimizationConfigsArray);
            }
        }
        return new OptimizeDatasetV2(opBuilder.build());
    }

    public static Options optimizationConfigs(List<String> optimizationConfigs) {
        return new Options().optimizationConfigs(optimizationConfigs);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private OptimizeDatasetV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private List<String> optimizationConfigs;

        public Options optimizationConfigs(List<String> optimizationConfigs) {
            this.optimizationConfigs = optimizationConfigs;
            return this;
        }

        private Options() {
        }
    }
}

