/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;

public final class QuantizeAndDequantizeV4<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "QuantizeAndDequantizeV4";
    private Output<T> output;

    public static <T extends TNumber> QuantizeAndDequantizeV4<T> create(Scope scope, Operand<T> input, Operand<T> inputMin, Operand<T> inputMax, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(inputMin.asOutput());
        opBuilder.addInput(inputMax.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.signedInput != null) {
                    opBuilder.setAttr("signed_input", opts.signedInput);
                }
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.rangeGiven != null) {
                    opBuilder.setAttr("range_given", opts.rangeGiven);
                }
                if (opts.roundMode != null) {
                    opBuilder.setAttr("round_mode", opts.roundMode);
                }
                if (opts.narrowRange != null) {
                    opBuilder.setAttr("narrow_range", opts.narrowRange);
                }
                if (opts.axis == null) continue;
                opBuilder.setAttr("axis", opts.axis);
            }
        }
        return new QuantizeAndDequantizeV4<T>(opBuilder.build());
    }

    public static Options signedInput(Boolean signedInput) {
        return new Options().signedInput(signedInput);
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options rangeGiven(Boolean rangeGiven) {
        return new Options().rangeGiven(rangeGiven);
    }

    public static Options roundMode(String roundMode) {
        return new Options().roundMode(roundMode);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private QuantizeAndDequantizeV4(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean signedInput;
        private Long numBits;
        private Boolean rangeGiven;
        private String roundMode;
        private Boolean narrowRange;
        private Long axis;

        public Options signedInput(Boolean signedInput) {
            this.signedInput = signedInput;
            return this;
        }

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options rangeGiven(Boolean rangeGiven) {
            this.rangeGiven = rangeGiven;
            return this;
        }

        public Options roundMode(String roundMode) {
            this.roundMode = roundMode;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }

        private Options() {
        }
    }
}

