/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.signal.BatchFft;
import org.tensorflow.op.signal.BatchFft2d;
import org.tensorflow.op.signal.BatchFft3d;
import org.tensorflow.op.signal.BatchIfft;
import org.tensorflow.op.signal.BatchIfft2d;
import org.tensorflow.op.signal.BatchIfft3d;
import org.tensorflow.op.signal.Fft;
import org.tensorflow.op.signal.Fft2d;
import org.tensorflow.op.signal.Fft3d;
import org.tensorflow.op.signal.Ifft;
import org.tensorflow.op.signal.Ifft2d;
import org.tensorflow.op.signal.Ifft3d;
import org.tensorflow.op.signal.Irfft;
import org.tensorflow.op.signal.Irfft2d;
import org.tensorflow.op.signal.Irfft3d;
import org.tensorflow.op.signal.Rfft;
import org.tensorflow.op.signal.Rfft2d;
import org.tensorflow.op.signal.Rfft3d;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class SignalOps {
    private final Scope scope;
    private final Ops ops;

    SignalOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public BatchFft batchFft(Operand<?> input) {
        return BatchFft.create(this.scope, input);
    }

    public BatchFft2d batchFft2d(Operand<?> input) {
        return BatchFft2d.create(this.scope, input);
    }

    public BatchFft3d batchFft3d(Operand<?> input) {
        return BatchFft3d.create(this.scope, input);
    }

    public BatchIfft batchIfft(Operand<?> input) {
        return BatchIfft.create(this.scope, input);
    }

    public BatchIfft2d batchIfft2d(Operand<?> input) {
        return BatchIfft2d.create(this.scope, input);
    }

    public BatchIfft3d batchIfft3d(Operand<?> input) {
        return BatchIfft3d.create(this.scope, input);
    }

    public <T extends TType> Fft<T> fft(Operand<T> input) {
        return Fft.create(this.scope, input);
    }

    public <T extends TType> Fft2d<T> fft2d(Operand<T> input) {
        return Fft2d.create(this.scope, input);
    }

    public <T extends TType> Fft3d<T> fft3d(Operand<T> input) {
        return Fft3d.create(this.scope, input);
    }

    public <T extends TType> Ifft<T> ifft(Operand<T> input) {
        return Ifft.create(this.scope, input);
    }

    public <T extends TType> Ifft2d<T> ifft2d(Operand<T> input) {
        return Ifft2d.create(this.scope, input);
    }

    public <T extends TType> Ifft3d<T> ifft3d(Operand<T> input) {
        return Ifft3d.create(this.scope, input);
    }

    public Irfft<TFloat32> irfft(Operand<? extends TType> input, Operand<TInt32> fftLength) {
        return Irfft.create(this.scope, input, fftLength);
    }

    public <U extends TNumber> Irfft<U> irfft(Operand<? extends TType> input, Operand<TInt32> fftLength, Class<U> Treal) {
        return Irfft.create(this.scope, input, fftLength, Treal);
    }

    public Irfft2d<TFloat32> irfft2d(Operand<? extends TType> input, Operand<TInt32> fftLength) {
        return Irfft2d.create(this.scope, input, fftLength);
    }

    public <U extends TNumber> Irfft2d<U> irfft2d(Operand<? extends TType> input, Operand<TInt32> fftLength, Class<U> Treal) {
        return Irfft2d.create(this.scope, input, fftLength, Treal);
    }

    public Irfft3d<TFloat32> irfft3d(Operand<? extends TType> input, Operand<TInt32> fftLength) {
        return Irfft3d.create(this.scope, input, fftLength);
    }

    public <U extends TNumber> Irfft3d<U> irfft3d(Operand<? extends TType> input, Operand<TInt32> fftLength, Class<U> Treal) {
        return Irfft3d.create(this.scope, input, fftLength, Treal);
    }

    public <U extends TType> Rfft<U> rfft(Operand<? extends TNumber> input, Operand<TInt32> fftLength, Class<U> Tcomplex) {
        return Rfft.create(this.scope, input, fftLength, Tcomplex);
    }

    public <U extends TType> Rfft2d<U> rfft2d(Operand<? extends TNumber> input, Operand<TInt32> fftLength, Class<U> Tcomplex) {
        return Rfft2d.create(this.scope, input, fftLength, Tcomplex);
    }

    public <U extends TType> Rfft3d<U> rfft3d(Operand<? extends TNumber> input, Operand<TInt32> fftLength, Class<U> Tcomplex) {
        return Rfft3d.create(this.scope, input, fftLength, Tcomplex);
    }

    public final Ops ops() {
        return this.ops;
    }
}

