/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TType;

public final class QuantizedBiasAdd<V extends TType>
extends RawOp {
    public static final String OP_NAME = "QuantizedBiasAdd";
    private Output<V> output;
    private Output<TFloat32> minOut;
    private Output<TFloat32> maxOut;

    public static <V extends TType, T extends TType, U extends TType> QuantizedBiasAdd<V> create(Scope scope, Operand<T> input, Operand<U> bias, Operand<TFloat32> minInput, Operand<TFloat32> maxInput, Operand<TFloat32> minBias, Operand<TFloat32> maxBias, DataType<V> outType) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(bias.asOutput());
        opBuilder.addInput(minInput.asOutput());
        opBuilder.addInput(maxInput.asOutput());
        opBuilder.addInput(minBias.asOutput());
        opBuilder.addInput(maxBias.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("out_type", outType);
        return new QuantizedBiasAdd<V>(opBuilder.build());
    }

    public Output<V> output() {
        return this.output;
    }

    public Output<TFloat32> minOut() {
        return this.minOut;
    }

    public Output<TFloat32> maxOut() {
        return this.maxOut;
    }

    private QuantizedBiasAdd(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.minOut = operation.output(outputIdx++);
        this.maxOut = operation.output(outputIdx++);
    }
}

