/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

public final class BoostedTreesCalculateBestGainsPerFeature
extends RawOp {
    public static final String OP_NAME = "BoostedTreesCalculateBestGainsPerFeature";
    private List<Output<TInt32>> nodeIdsList;
    private List<Output<TFloat32>> gainsList;
    private List<Output<TInt32>> thresholdsList;
    private List<Output<TFloat32>> leftNodeContribsList;
    private List<Output<TFloat32>> rightNodeContribsList;

    public static BoostedTreesCalculateBestGainsPerFeature create(Scope scope, Operand<TInt32> nodeIdRange, Iterable<Operand<TFloat32>> statsSummaryList, Operand<TFloat32> l1, Operand<TFloat32> l2, Operand<TFloat32> treeComplexity, Operand<TFloat32> minNodeWeight, Long maxSplits) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(nodeIdRange.asOutput());
        opBuilder.addInputList(Operands.asOutputs(statsSummaryList));
        opBuilder.addInput(l1.asOutput());
        opBuilder.addInput(l2.asOutput());
        opBuilder.addInput(treeComplexity.asOutput());
        opBuilder.addInput(minNodeWeight.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("max_splits", maxSplits);
        return new BoostedTreesCalculateBestGainsPerFeature(opBuilder.build());
    }

    public List<Output<TInt32>> nodeIdsList() {
        return this.nodeIdsList;
    }

    public List<Output<TFloat32>> gainsList() {
        return this.gainsList;
    }

    public List<Output<TInt32>> thresholdsList() {
        return this.thresholdsList;
    }

    public List<Output<TFloat32>> leftNodeContribsList() {
        return this.leftNodeContribsList;
    }

    public List<Output<TFloat32>> rightNodeContribsList() {
        return this.rightNodeContribsList;
    }

    private BoostedTreesCalculateBestGainsPerFeature(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int nodeIdsListLength = operation.outputListLength("node_ids_list");
        this.nodeIdsList = Arrays.asList(operation.outputList(outputIdx, nodeIdsListLength));
        int gainsListLength = operation.outputListLength("gains_list");
        this.gainsList = Arrays.asList(operation.outputList(outputIdx += nodeIdsListLength, gainsListLength));
        int thresholdsListLength = operation.outputListLength("thresholds_list");
        this.thresholdsList = Arrays.asList(operation.outputList(outputIdx += gainsListLength, thresholdsListLength));
        int leftNodeContribsListLength = operation.outputListLength("left_node_contribs_list");
        this.leftNodeContribsList = Arrays.asList(operation.outputList(outputIdx += thresholdsListLength, leftNodeContribsListLength));
        int rightNodeContribsListLength = operation.outputListLength("right_node_contribs_list");
        this.rightNodeContribsList = Arrays.asList(operation.outputList(outputIdx += leftNodeContribsListLength, rightNodeContribsListLength));
        outputIdx += rightNodeContribsListLength;
    }
}

