/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class Gather<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "GatherV2";
    private Output<T> output;

    public static <T extends TType, U extends TNumber, V extends TNumber> Gather<T> create(Scope scope, Operand<T> params, Operand<U> indices, Operand<V> axis, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("Gather"));
        opBuilder.addInput(params.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(axis.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.batchDims == null) continue;
                opBuilder.setAttr("batch_dims", opts.batchDims);
            }
        }
        return new Gather<T>(opBuilder.build());
    }

    public static Options batchDims(Long batchDims) {
        return new Options().batchDims(batchDims);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private Gather(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long batchDims;

        public Options batchDims(Long batchDims) {
            this.batchDims = batchDims;
            return this;
        }

        private Options() {
        }
    }
}

