/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxJavaType;
import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtAllocator;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtUtil;
import ai.onnxruntime.TensorInfo;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class OnnxTensor
implements OnnxValue {
    private final long nativeHandle;
    private final long allocatorHandle;
    private final TensorInfo info;
    private final Buffer buffer;

    OnnxTensor(long nativeHandle, long allocatorHandle, TensorInfo info) {
        this(nativeHandle, allocatorHandle, info, null);
    }

    OnnxTensor(long nativeHandle, long allocatorHandle, TensorInfo info, Buffer buffer) {
        this.nativeHandle = nativeHandle;
        this.allocatorHandle = allocatorHandle;
        this.info = info;
        this.buffer = buffer;
    }

    @Override
    public OnnxValue.OnnxValueType getType() {
        return OnnxValue.OnnxValueType.ONNX_TYPE_TENSOR;
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    @Override
    public Object getValue() throws OrtException {
        if (this.info.isScalar()) {
            switch (this.info.type) {
                case FLOAT: {
                    return Float.valueOf(this.getFloat(OnnxRuntime.ortApiHandle, this.nativeHandle, this.info.onnxType.value));
                }
                case DOUBLE: {
                    return this.getDouble(OnnxRuntime.ortApiHandle, this.nativeHandle);
                }
                case INT8: {
                    return this.getByte(OnnxRuntime.ortApiHandle, this.nativeHandle, this.info.onnxType.value);
                }
                case INT16: {
                    return this.getShort(OnnxRuntime.ortApiHandle, this.nativeHandle, this.info.onnxType.value);
                }
                case INT32: {
                    return this.getInt(OnnxRuntime.ortApiHandle, this.nativeHandle, this.info.onnxType.value);
                }
                case INT64: {
                    return this.getLong(OnnxRuntime.ortApiHandle, this.nativeHandle, this.info.onnxType.value);
                }
                case BOOL: {
                    return this.getBool(OnnxRuntime.ortApiHandle, this.nativeHandle);
                }
                case STRING: {
                    return this.getString(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
                }
            }
            throw new OrtException("Extracting the value of an invalid Tensor.");
        }
        Object carrier = this.info.makeCarrier();
        this.getArray(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle, carrier);
        return carrier;
    }

    @Override
    public TensorInfo getInfo() {
        return this.info;
    }

    public String toString() {
        return "OnnxTensor(info=" + this.info.toString() + ")";
    }

    @Override
    public void close() {
        this.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
    }

    public ByteBuffer getByteBuffer() {
        if (this.info.type != OnnxJavaType.STRING) {
            ByteBuffer buffer = this.getBuffer(OnnxRuntime.ortApiHandle, this.nativeHandle);
            ByteBuffer output = ByteBuffer.allocate(buffer.capacity());
            output.put(buffer);
            output.rewind();
            return output;
        }
        return null;
    }

    public FloatBuffer getFloatBuffer() {
        if (this.info.type == OnnxJavaType.FLOAT) {
            if (this.info.onnxType == TensorInfo.OnnxTensorType.ONNX_TENSOR_ELEMENT_DATA_TYPE_FLOAT16) {
                ShortBuffer buffer = this.getBuffer().asShortBuffer();
                int bufferCap = buffer.capacity();
                FloatBuffer output = FloatBuffer.allocate(bufferCap);
                for (int i = 0; i < bufferCap; ++i) {
                    output.put(OnnxTensor.fp16ToFloat(buffer.get(i)));
                }
                output.rewind();
                return output;
            }
            FloatBuffer buffer = this.getBuffer().asFloatBuffer();
            FloatBuffer output = FloatBuffer.allocate(buffer.capacity());
            output.put(buffer);
            output.rewind();
            return output;
        }
        return null;
    }

    public DoubleBuffer getDoubleBuffer() {
        if (this.info.type == OnnxJavaType.DOUBLE) {
            DoubleBuffer buffer = this.getBuffer().asDoubleBuffer();
            DoubleBuffer output = DoubleBuffer.allocate(buffer.capacity());
            output.put(buffer);
            output.rewind();
            return output;
        }
        return null;
    }

    public ShortBuffer getShortBuffer() {
        if (this.info.type == OnnxJavaType.INT16) {
            ShortBuffer buffer = this.getBuffer().asShortBuffer();
            ShortBuffer output = ShortBuffer.allocate(buffer.capacity());
            output.put(buffer);
            output.rewind();
            return output;
        }
        return null;
    }

    public IntBuffer getIntBuffer() {
        if (this.info.type == OnnxJavaType.INT32) {
            IntBuffer buffer = this.getBuffer().asIntBuffer();
            IntBuffer output = IntBuffer.allocate(buffer.capacity());
            output.put(buffer);
            output.rewind();
            return output;
        }
        return null;
    }

    public LongBuffer getLongBuffer() {
        if (this.info.type == OnnxJavaType.INT64) {
            LongBuffer buffer = this.getBuffer().asLongBuffer();
            LongBuffer output = LongBuffer.allocate(buffer.capacity());
            output.put(buffer);
            output.rewind();
            return output;
        }
        return null;
    }

    private ByteBuffer getBuffer() {
        return this.getBuffer(OnnxRuntime.ortApiHandle, this.nativeHandle).order(ByteOrder.nativeOrder());
    }

    private native ByteBuffer getBuffer(long var1, long var3);

    private native float getFloat(long var1, long var3, int var5) throws OrtException;

    private native double getDouble(long var1, long var3) throws OrtException;

    private native byte getByte(long var1, long var3, int var5) throws OrtException;

    private native short getShort(long var1, long var3, int var5) throws OrtException;

    private native int getInt(long var1, long var3, int var5) throws OrtException;

    private native long getLong(long var1, long var3, int var5) throws OrtException;

    private native String getString(long var1, long var3, long var5) throws OrtException;

    private native boolean getBool(long var1, long var3) throws OrtException;

    private native void getArray(long var1, long var3, long var5, Object var7) throws OrtException;

    private native void close(long var1, long var3);

    private static float fp16ToFloat(short input) {
        int output = (input & 0x8000) << 16 | (input & 0x7C00) + 114688 << 13 | (input & 0x3FF) << 13;
        return Float.intBitsToFloat(output);
    }

    public static OnnxTensor createTensor(OrtEnvironment env, Object data) throws OrtException {
        return OnnxTensor.createTensor(env, env.defaultAllocator, data);
    }

    static OnnxTensor createTensor(OrtEnvironment env, OrtAllocator allocator, Object data) throws OrtException {
        if (!env.isClosed() && !allocator.isClosed()) {
            TensorInfo info = TensorInfo.constructFromJavaArray(data);
            if (info.type == OnnxJavaType.STRING) {
                if (info.shape.length == 0) {
                    return new OnnxTensor(OnnxTensor.createString(OnnxRuntime.ortApiHandle, allocator.handle, (String)data), allocator.handle, info);
                }
                return new OnnxTensor(OnnxTensor.createStringTensor(OnnxRuntime.ortApiHandle, allocator.handle, OrtUtil.flattenString(data), info.shape), allocator.handle, info);
            }
            if (info.shape.length == 0) {
                data = OrtUtil.convertBoxedPrimitiveToArray(data);
            }
            return new OnnxTensor(OnnxTensor.createTensor(OnnxRuntime.ortApiHandle, allocator.handle, data, info.shape, info.onnxType.value), allocator.handle, info);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor with a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment env, String[] data, long[] shape) throws OrtException {
        return OnnxTensor.createTensor(env, env.defaultAllocator, data, shape);
    }

    static OnnxTensor createTensor(OrtEnvironment env, OrtAllocator allocator, String[] data, long[] shape) throws OrtException {
        if (!env.isClosed() && !allocator.isClosed()) {
            TensorInfo info = new TensorInfo(shape, OnnxJavaType.STRING, TensorInfo.OnnxTensorType.ONNX_TENSOR_ELEMENT_DATA_TYPE_STRING);
            return new OnnxTensor(OnnxTensor.createStringTensor(OnnxRuntime.ortApiHandle, allocator.handle, data, shape), allocator.handle, info);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment env, FloatBuffer data, long[] shape) throws OrtException {
        return OnnxTensor.createTensor(env, env.defaultAllocator, data, shape);
    }

    static OnnxTensor createTensor(OrtEnvironment env, OrtAllocator allocator, FloatBuffer data, long[] shape) throws OrtException {
        if (!env.isClosed() && !allocator.isClosed()) {
            FloatBuffer tmp;
            OnnxJavaType type = OnnxJavaType.FLOAT;
            int bufferSize = data.capacity() * type.size;
            if (data.isDirect()) {
                tmp = data;
            } else {
                ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.nativeOrder());
                tmp = buffer.asFloatBuffer();
                tmp.put(data);
            }
            TensorInfo info = TensorInfo.constructFromBuffer(tmp, shape, type);
            return new OnnxTensor(OnnxTensor.createTensorFromBuffer(OnnxRuntime.ortApiHandle, allocator.handle, tmp, bufferSize, shape, info.onnxType.value), allocator.handle, info, tmp);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment env, DoubleBuffer data, long[] shape) throws OrtException {
        return OnnxTensor.createTensor(env, env.defaultAllocator, data, shape);
    }

    static OnnxTensor createTensor(OrtEnvironment env, OrtAllocator allocator, DoubleBuffer data, long[] shape) throws OrtException {
        if (!env.isClosed() && !allocator.isClosed()) {
            DoubleBuffer tmp;
            OnnxJavaType type = OnnxJavaType.DOUBLE;
            int bufferSize = data.capacity() * type.size;
            if (data.isDirect()) {
                tmp = data;
            } else {
                ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.nativeOrder());
                tmp = buffer.asDoubleBuffer();
                tmp.put(data);
            }
            TensorInfo info = TensorInfo.constructFromBuffer(tmp, shape, type);
            return new OnnxTensor(OnnxTensor.createTensorFromBuffer(OnnxRuntime.ortApiHandle, allocator.handle, tmp, bufferSize, shape, info.onnxType.value), allocator.handle, info, tmp);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment env, ByteBuffer data, long[] shape) throws OrtException {
        return OnnxTensor.createTensor(env, env.defaultAllocator, data, shape);
    }

    static OnnxTensor createTensor(OrtEnvironment env, OrtAllocator allocator, ByteBuffer data, long[] shape) throws OrtException {
        return OnnxTensor.createTensor(env, allocator, data, shape, OnnxJavaType.INT8);
    }

    public static OnnxTensor createTensor(OrtEnvironment env, ByteBuffer data, long[] shape, OnnxJavaType type) throws OrtException {
        return OnnxTensor.createTensor(env, env.defaultAllocator, data, shape, type);
    }

    static OnnxTensor createTensor(OrtEnvironment env, OrtAllocator allocator, ByteBuffer data, long[] shape, OnnxJavaType type) throws OrtException {
        if (!env.isClosed() && !allocator.isClosed()) {
            ByteBuffer tmp;
            int bufferSize = data.capacity();
            if (data.isDirect()) {
                tmp = data;
            } else {
                tmp = ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.nativeOrder());
                tmp.put(data);
            }
            TensorInfo info = TensorInfo.constructFromBuffer(tmp, shape, type);
            return new OnnxTensor(OnnxTensor.createTensorFromBuffer(OnnxRuntime.ortApiHandle, allocator.handle, tmp, bufferSize, shape, info.onnxType.value), allocator.handle, info, tmp);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment env, ShortBuffer data, long[] shape) throws OrtException {
        return OnnxTensor.createTensor(env, env.defaultAllocator, data, shape);
    }

    static OnnxTensor createTensor(OrtEnvironment env, OrtAllocator allocator, ShortBuffer data, long[] shape) throws OrtException {
        if (!env.isClosed() && !allocator.isClosed()) {
            ShortBuffer tmp;
            OnnxJavaType type = OnnxJavaType.INT16;
            int bufferSize = data.capacity() * type.size;
            if (data.isDirect()) {
                tmp = data;
            } else {
                ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.nativeOrder());
                tmp = buffer.asShortBuffer();
                tmp.put(data);
            }
            TensorInfo info = TensorInfo.constructFromBuffer(tmp, shape, type);
            return new OnnxTensor(OnnxTensor.createTensorFromBuffer(OnnxRuntime.ortApiHandle, allocator.handle, tmp, bufferSize, shape, info.onnxType.value), allocator.handle, info, tmp);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment env, IntBuffer data, long[] shape) throws OrtException {
        return OnnxTensor.createTensor(env, env.defaultAllocator, data, shape);
    }

    static OnnxTensor createTensor(OrtEnvironment env, OrtAllocator allocator, IntBuffer data, long[] shape) throws OrtException {
        if (!env.isClosed() && !allocator.isClosed()) {
            IntBuffer tmp;
            OnnxJavaType type = OnnxJavaType.INT32;
            int bufferSize = data.capacity() * type.size;
            if (data.isDirect()) {
                tmp = data;
            } else {
                ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.nativeOrder());
                tmp = buffer.asIntBuffer();
                tmp.put(data);
            }
            TensorInfo info = TensorInfo.constructFromBuffer(tmp, shape, type);
            return new OnnxTensor(OnnxTensor.createTensorFromBuffer(OnnxRuntime.ortApiHandle, allocator.handle, tmp, bufferSize, shape, info.onnxType.value), allocator.handle, info, tmp);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    public static OnnxTensor createTensor(OrtEnvironment env, LongBuffer data, long[] shape) throws OrtException {
        return OnnxTensor.createTensor(env, env.defaultAllocator, data, shape);
    }

    static OnnxTensor createTensor(OrtEnvironment env, OrtAllocator allocator, LongBuffer data, long[] shape) throws OrtException {
        if (!env.isClosed() && !allocator.isClosed()) {
            LongBuffer tmp;
            OnnxJavaType type = OnnxJavaType.INT64;
            int bufferSize = data.capacity() * type.size;
            if (data.isDirect()) {
                tmp = data;
            } else {
                ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.nativeOrder());
                tmp = buffer.asLongBuffer();
                tmp.put(data);
            }
            TensorInfo info = TensorInfo.constructFromBuffer(tmp, shape, type);
            return new OnnxTensor(OnnxTensor.createTensorFromBuffer(OnnxRuntime.ortApiHandle, allocator.handle, tmp, bufferSize, shape, info.onnxType.value), allocator.handle, info, tmp);
        }
        throw new IllegalStateException("Trying to create an OnnxTensor on a closed OrtAllocator.");
    }

    private static native long createTensor(long var0, long var2, Object var4, long[] var5, int var6) throws OrtException;

    private static native long createTensorFromBuffer(long var0, long var2, Buffer var4, long var5, long[] var7, int var8) throws OrtException;

    private static native long createString(long var0, long var2, String var4) throws OrtException;

    private static native long createStringTensor(long var0, long var2, Object[] var4, long[] var5) throws OrtException;

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load onnx-runtime library", e);
        }
    }
}

