/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.jna;

import com.sun.jna.Pointer;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NativeResource
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(NativeResource.class);
    protected final AtomicReference<Pointer> handle;
    private String uid;
    private Exception exception;

    protected NativeResource(Pointer pointer) {
        this.handle = new AtomicReference<Pointer>(pointer);
        this.uid = String.valueOf(Pointer.nativeValue((Pointer)pointer));
        if (logger.isTraceEnabled()) {
            this.exception = new Exception();
        }
    }

    public boolean isReleased() {
        return this.handle.get() == null;
    }

    public Pointer getHandle() {
        Pointer pointer = this.handle.get();
        if (pointer == null) {
            throw new IllegalStateException("Native resource has been release already.");
        }
        return pointer;
    }

    public final String getUid() {
        return this.uid;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    protected void finalize() throws Throwable {
        if (this.handle.get() != null && this.exception != null) {
            logger.warn("Resource ({}) was not closed explicitly: {}", (Object)this.getUid(), (Object)this.getClass().getSimpleName());
            logger.warn("Resource was created:", (Throwable)this.exception);
        }
        this.close();
        super.finalize();
    }
}

