/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.engine.EngineException;
import ai.djl.mxnet.engine.MxGradientCollector;
import ai.djl.mxnet.engine.MxModel;
import ai.djl.mxnet.engine.MxNDManager;
import ai.djl.mxnet.engine.MxParameterServer;
import ai.djl.mxnet.engine.MxSymbolBlock;
import ai.djl.mxnet.jna.JnaUtils;
import ai.djl.mxnet.jna.LibUtils;
import ai.djl.ndarray.NDManager;
import ai.djl.nn.SymbolBlock;
import ai.djl.training.GradientCollector;
import ai.djl.training.LocalParameterServer;
import ai.djl.training.ParameterServer;
import ai.djl.training.optimizer.Optimizer;
import ai.djl.util.RandomUtils;
import ai.djl.util.Utils;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class MxEngine
extends Engine {
    public static final String ENGINE_NAME = "MXNet";
    static final int RANK = 1;
    private static final String MXNET_EXTRA_LIBRARY_VERBOSE = "MXNET_EXTRA_LIBRARY_VERBOSE";

    private MxEngine() {
    }

    static Engine newInstance() {
        try {
            JnaUtils.getAllOpNames();
            JnaUtils.setNumpyMode(JnaUtils.NumpyMode.GLOBAL_ON);
            Runtime.getRuntime().addShutdownHook(new Thread(JnaUtils::waitAll));
            String paths = Utils.getEnvOrSystemProperty((String)"MXNET_EXTRA_LIBRARY_PATH");
            boolean extraLibVerbose = Boolean.parseBoolean(Utils.getEnvOrSystemProperty((String)MXNET_EXTRA_LIBRARY_VERBOSE));
            if (paths != null) {
                String[] files;
                for (String file : files = paths.split(",")) {
                    Path path = Paths.get(file, new String[0]);
                    if (Files.notExists(path, new LinkOption[0])) {
                        throw new FileNotFoundException("Extra Library not found: " + file);
                    }
                    JnaUtils.loadLib(path.toAbsolutePath().toString(), extraLibVerbose);
                }
            }
            return new MxEngine();
        }
        catch (Throwable t) {
            throw new EngineException("Failed to load MXNet native library", t);
        }
    }

    public Engine getAlternativeEngine() {
        return null;
    }

    public String getEngineName() {
        return ENGINE_NAME;
    }

    public int getRank() {
        return 1;
    }

    public String getVersion() {
        int version = JnaUtils.getVersion();
        int major = version / 10000;
        int minor = version / 100 - major * 100;
        int patch = version % 100;
        return major + "." + minor + '.' + patch;
    }

    public boolean hasCapability(String capability) {
        return JnaUtils.getFeatures().contains(capability);
    }

    public SymbolBlock newSymbolBlock(NDManager manager) {
        return new MxSymbolBlock(manager);
    }

    public Model newModel(String name, Device device) {
        return new MxModel(name, device);
    }

    public NDManager newBaseManager() {
        return MxNDManager.getSystemManager().newSubManager();
    }

    public NDManager newBaseManager(Device device) {
        return MxNDManager.getSystemManager().newSubManager(device);
    }

    public GradientCollector newGradientCollector() {
        return new MxGradientCollector();
    }

    public ParameterServer newParameterServer(Optimizer optimizer) {
        return Boolean.getBoolean("ai.djl.use_local_parameter_server") ? new LocalParameterServer(optimizer) : new MxParameterServer(optimizer);
    }

    public void setRandomSeed(int seed) {
        super.setRandomSeed(seed);
        JnaUtils.randomSeed(seed);
        RandomUtils.RANDOM.setSeed(seed);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getEngineName()).append(':').append(this.getVersion()).append(", capabilities: [\n");
        for (String feature : JnaUtils.getFeatures()) {
            sb.append("\t").append(feature).append(",\n");
        }
        sb.append("]\nMXNet Library: ").append(LibUtils.getLibName());
        return sb.toString();
    }
}

