/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.Repository;
import ai.djl.repository.Resource;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.training.dataset.Record;
import ai.djl.translate.TranslateException;
import ai.djl.util.Pair;
import ai.djl.util.PairList;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImageFolder
extends RandomAccessDataset {
    private static final Logger logger = LoggerFactory.getLogger(AbstractImageFolder.class);
    private static final Set<String> EXT = new HashSet<String>(Arrays.asList(".jpg", ".jpeg", ".png", ".bmp", ".wbmp", ".gif"));
    protected Image.Flag flag;
    protected List<String> synset;
    protected PairList<String, Integer> items;
    protected Resource resource;
    protected boolean prepared;
    private int maxDepth;

    protected AbstractImageFolder(ImageFolderBuilder<?> builder) {
        super(builder);
        this.flag = builder.flag;
        this.maxDepth = builder.maxDepth;
        this.synset = new ArrayList<String>();
        this.items = new PairList();
        this.resource = new Resource(builder.repository, null, "1.0");
    }

    protected Record get(NDManager manager, long index) throws IOException {
        Pair item = this.items.get(Math.toIntExact(index));
        Path imagePath = this.getImagePath((String)item.getKey());
        NDArray array = ImageFactory.getInstance().fromFile(imagePath).toNDArray(manager, this.flag);
        NDList d = new NDList(new NDArray[]{array});
        NDList l = new NDList(new NDArray[]{manager.create((Number)item.getValue())});
        return new Record(d, l);
    }

    protected long availableSize() {
        return this.items.size();
    }

    public List<String> getSynset() throws IOException, TranslateException {
        this.prepare();
        return this.synset;
    }

    protected void listImages(Path root, List<String> classes) {
        int label = 0;
        for (String className : classes) {
            Path classFolder = root.resolve(className);
            if (!Files.isDirectory(classFolder, new LinkOption[0])) continue;
            try (Stream<Path> stream = Files.walk(classFolder, this.maxDepth, new FileVisitOption[0]);){
                int classLabel = label;
                stream.forEach(p -> {
                    if (this.isImage(p.toFile())) {
                        String path = p.toAbsolutePath().toString();
                        this.items.add(new Pair((Object)path, (Object)classLabel));
                    }
                });
            }
            catch (IOException e) {
                logger.warn("Failed to list images", (Throwable)e);
            }
            logger.debug("Loaded {} images in {}, class: {}", new Object[]{this.items.size(), classFolder, label});
            ++label;
        }
    }

    protected abstract Path getImagePath(String var1);

    private boolean isImage(File file) {
        String path = file.getName();
        if (!file.isFile() || file.isHidden() || path.startsWith(".")) {
            return false;
        }
        int extensionIndex = path.lastIndexOf(46);
        if (extensionIndex < 0) {
            return false;
        }
        return EXT.contains(path.substring(extensionIndex).toLowerCase());
    }

    public static abstract class ImageFolderBuilder<T extends ImageFolderBuilder>
    extends RandomAccessDataset.BaseBuilder<T> {
        Repository repository;
        Image.Flag flag = Image.Flag.COLOR;
        int maxDepth = 1;

        protected ImageFolderBuilder() {
        }

        public T optFlag(Image.Flag flag) {
            this.flag = flag;
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }

        public T setRepository(Repository repository) {
            this.repository = repository;
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }

        public T setRepositoryPath(String path) {
            this.repository = Repository.newInstance((String)"images", (String)path);
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }

        public T setRepositoryPath(Path path) {
            this.repository = Repository.newInstance((String)"images", (Path)path);
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }

        public T optMaxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }
    }
}

