/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.tabular;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.tabular.CsvDataset;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.Shape;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.training.dataset.Dataset;
import ai.djl.util.Progress;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

public final class AirfoilRandomAccess
extends CsvDataset {
    private static final String ARTIFACT_ID = "airfoil";
    private static final String VERSION = "1.0";
    private static final String[] COLUMNS = new String[]{"freq", "aoa", "chordlen", "freestreamvel", "ssdt", "ssoundpres"};
    private MRL mrl;
    private Dataset.Usage usage;
    private boolean prepared;
    private boolean normalize;
    private Map<String, Float> mean;
    private Map<String, Float> std;

    AirfoilRandomAccess(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
        this.normalize = builder.normalize;
    }

    @Override
    public void prepare(Progress progress) throws IOException {
        Path csvFile;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact);
        Path root = this.mrl.getRepository().getResourceDirectory(artifact);
        switch (this.usage) {
            case TRAIN: {
                csvFile = root.resolve("airfoil_self_noise.dat");
                break;
            }
            case TEST: {
                throw new UnsupportedOperationException("Test data not available.");
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        this.csvUrl = csvFile.toUri().toURL();
        super.prepare(progress);
        if (this.normalize) {
            this.mean = new HashMap<String, Float>();
            this.std = new HashMap<String, Float>();
            for (CsvDataset.Feature feature : this.features) {
                this.calculateMean(feature.getName());
                this.calculateStd(feature.getName());
            }
            for (CsvDataset.Feature feature : this.labels) {
                this.calculateMean(feature.getName());
                this.calculateStd(feature.getName());
            }
        }
        this.prepared = true;
    }

    @Override
    public List<String> getColumnNames() {
        return Arrays.asList(COLUMNS).subList(0, 5);
    }

    @Override
    protected NDList toNDList(NDManager manager, CSVRecord record, List<CsvDataset.Feature> selected) {
        int length = selected.size();
        ByteBuffer bb = manager.allocateDirect(length * 4);
        FloatBuffer buf = bb.asFloatBuffer();
        int index = 0;
        for (CsvDataset.Feature feature : selected) {
            String name = feature.getName();
            float value = Float.parseFloat(record.get(name));
            if (this.normalize) {
                value = (value - this.mean.get(name).floatValue()) / this.std.get(name).floatValue();
            }
            buf.put(value);
            ++index;
        }
        buf.rewind();
        return new NDList(new NDArray[]{manager.create((Buffer)buf, new Shape(new long[]{length}))});
    }

    private void calculateMean(String column) {
        float sum = 0.0f;
        long size = this.size();
        int i = 0;
        while ((long)i < size) {
            CSVRecord record = (CSVRecord)this.csvRecords.get(i);
            sum += Float.parseFloat(record.get(column));
            ++i;
        }
        this.mean.put(column, Float.valueOf(sum / (float)size));
    }

    private void calculateStd(String column) {
        float average = this.mean.get(column).floatValue();
        float sum = 0.0f;
        long size = this.size();
        int i = 0;
        while ((long)i < size) {
            CSVRecord record = (CSVRecord)this.csvRecords.get(i);
            sum += (float)Math.pow(Float.parseFloat(record.get(column)) - average, 2.0);
            ++i;
        }
        this.std.put(column, Float.valueOf((float)Math.sqrt(sum / (float)size)));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends CsvDataset.CsvBuilder<Builder> {
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "airfoil";
        Dataset.Usage usage = Dataset.Usage.TRAIN;
        boolean normalize;

        Builder() {
            this.csvFormat = CSVFormat.TDF.withHeader(COLUMNS).withIgnoreHeaderCase().withTrim();
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this;
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder optNormalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public List<String> getAvailableFeatures() {
            return Arrays.asList(COLUMNS);
        }

        public Builder addFeature(String name) {
            return (Builder)((Object)this.addFeature(new CsvDataset.Feature(name, true)));
        }

        @Override
        public AirfoilRandomAccess build() {
            if (this.features.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    this.addFeature(COLUMNS[i]);
                }
            }
            if (this.labels.isEmpty()) {
                this.addNumericLabel("ssoundpres");
            }
            return new AirfoilRandomAccess(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.Tabular.ANY, this.groupId, this.artifactId, AirfoilRandomAccess.VERSION);
        }
    }
}

