/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.cv.CocoMetadata;
import ai.djl.basicdataset.cv.CocoUtils;
import ai.djl.basicdataset.cv.ImageDataset;
import ai.djl.basicdataset.cv.ObjectDetectionDataset;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.Point;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.training.dataset.Dataset;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.util.PairList;
import ai.djl.util.Progress;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CocoDetection
extends ObjectDetectionDataset {
    private static final String ARTIFACT_ID = "coco";
    private static final String VERSION = "1.0";
    private Dataset.Usage usage;
    private List<Path> imagePaths;
    private List<PairList<Long, Rectangle>> labels;
    private MRL mrl;
    private boolean prepared;

    CocoDetection(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
        this.imagePaths = new ArrayList<Path>();
        this.labels = new ArrayList<PairList<Long, Rectangle>>();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PairList<Long, Rectangle> getObjects(long index) {
        return this.labels.get(Math.toIntExact(index));
    }

    public void prepare(Progress progress) throws IOException {
        Path jsonFile;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact, progress);
        Path root = this.mrl.getRepository().getResourceDirectory(artifact);
        switch (this.usage) {
            case TRAIN: {
                jsonFile = root.resolve("annotations").resolve("instances_train2017.json");
                break;
            }
            case TEST: {
                jsonFile = root.resolve("annotations").resolve("instances_val2017.json");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        CocoUtils coco = new CocoUtils(jsonFile);
        coco.prepare();
        List<Long> imageIds = coco.getImageIds();
        for (long id : imageIds) {
            Path imagePath = root.resolve(coco.getRelativeImagePath(id));
            PairList<Long, Rectangle> labelOfImageId = this.getLabels(coco, id);
            if (labelOfImageId.isEmpty()) continue;
            this.imagePaths.add(imagePath);
            this.labels.add(labelOfImageId);
        }
        this.prepared = true;
    }

    protected long availableSize() {
        return this.imagePaths.size();
    }

    private PairList<Long, Rectangle> getLabels(CocoUtils coco, long imageId) {
        List<Long> annotationIds = coco.getAnnotationIdByImageId(imageId);
        if (annotationIds == null) {
            return new PairList();
        }
        PairList label = new PairList(annotationIds.size());
        for (long annotationId : annotationIds) {
            CocoMetadata.Annotation annotation = coco.getAnnotationById(annotationId);
            if (!(annotation.getArea() > 0.0)) continue;
            double[] box = annotation.getBoundingBox();
            long labelClass = coco.mapCategoryId(annotation.getCategoryId());
            Rectangle objectLocation = new Rectangle(new Point(box[0], box[1]), box[2], box[3]);
            label.add((Object)labelClass, (Object)objectLocation);
        }
        return label;
    }

    @Override
    protected Image getImage(long index) throws IOException {
        int idx = Math.toIntExact(index);
        return ImageFactory.getInstance().fromFile(this.imagePaths.get(idx));
    }

    @Override
    public Optional<Integer> getImageWidth() {
        return Optional.empty();
    }

    @Override
    public Optional<Integer> getImageHeight() {
        return Optional.empty();
    }

    public static final class Builder
    extends ImageDataset.BaseBuilder<Builder> {
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "coco";
        Dataset.Usage usage = Dataset.Usage.TRAIN;

        Builder() {
            this.flag = Image.Flag.COLOR;
        }

        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this.self();
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this.self();
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public CocoDetection build() {
            if (this.pipeline == null) {
                this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
            }
            return new CocoDetection(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.CV.ANY, this.groupId, this.artifactId, CocoDetection.VERSION);
        }
    }
}

